/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.renderer.StaticTileRenderer;
import org.mini2Dx.tiled.renderer.TileFrame;
import org.mini2Dx.tiled.renderer.TileRenderer;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class AnimatedTileRenderer
implements TileRenderer {
    public static final int RENDERER_TYPE = 1;
    private final TileFrame[] frames;
    private final TilesetSource tilesetSource;
    private int currentFrame;
    private float timer;
    private long lastFrameId;

    public AnimatedTileRenderer(TilesetSource tilesetSource, TileFrame[] frames) {
        this.tilesetSource = tilesetSource;
        this.frames = frames;
    }

    public static AnimatedTileRenderer fromInputStream(TilesetSource tilesetSource, DataInputStream inputStream) throws IOException {
        int totalFrames = inputStream.readInt();
        AnimatedTileRenderer result = new AnimatedTileRenderer(tilesetSource, new TileFrame[totalFrames]);
        result.readData(inputStream);
        return result;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.frames.length);
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i].writeData(outputStream);
        }
    }

    public void readData(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i] = TileFrame.fromInputStream(inputStream);
        }
    }

    @Override
    public void update(Tile tile, float delta) {
        long currentFrameId = Mdx.graphicsContext.getFrameId();
        if (currentFrameId <= this.lastFrameId) {
            return;
        }
        this.timer += delta;
        while (this.timer >= this.frames[this.currentFrame].duration) {
            this.timer -= this.frames[this.currentFrame].duration;
            this.currentFrame = this.currentFrame == this.frames.length - 1 ? 0 : this.currentFrame + 1;
        }
        this.lastFrameId = currentFrameId;
    }

    @Override
    public void draw(Graphics g, Tile tile, int renderX, int renderY, float alpha) {
        Sprite tileImage = this.getCurrentTileImage(tile);
        tileImage.setAlpha(alpha);
        tileImage.setPosition((float)renderX, (float)renderY);
        g.drawSprite(tileImage);
    }

    @Override
    public void draw(Graphics g, Tile tile, int renderX, int renderY, float alpha, boolean flipH, boolean flipV, boolean flipD) {
        StaticTileRenderer.drawTileImage(g, this.getCurrentTileImage(tile), renderX, renderY, alpha, flipH, flipV, flipD);
    }

    @Override
    public Sprite getCurrentTileImage(Tile tile) {
        return this.tilesetSource.getTileImage(this.frames[this.currentFrame].tileId);
    }

    @Override
    public int getRendererType() {
        return 1;
    }

    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimatedTileRenderer that = (AnimatedTileRenderer)o;
        return Arrays.equals(this.frames, that.frames);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.frames);
    }
}

