/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;

public class HexagonalTileLayerRenderer
implements TileLayerRenderer {
    private final TiledMap tiledMap;
    private final IntMap<Tileset> tileIdToTileset;
    private final int hexWidth;
    private final int hexHeight;
    private final int sideOffsetX;
    private final int sideOffsetY;
    private final int quarterHexWidth;
    private final int quarterHexHeight;
    private final int halfHexWidth;
    private final int halfHexHeight;
    private final int threeQuarterHexWidth;
    private final int threeQuarterHexHeight;

    public HexagonalTileLayerRenderer(TiledMap tiledMap, IntMap<Tileset> tileIdToTileset) {
        this.tiledMap = tiledMap;
        this.tileIdToTileset = tileIdToTileset;
        this.sideOffsetX = (tiledMap.getTileWidth() - tiledMap.getSideLength() * 2) / 2;
        this.sideOffsetY = (tiledMap.getTileHeight() - tiledMap.getSideLength() * 2) / 2;
        switch (tiledMap.getStaggerAxis()) {
            case X: {
                this.hexWidth = tiledMap.getSideLength() * 2 + this.sideOffsetX;
                this.hexHeight = tiledMap.getTileHeight();
                break;
            }
            default: {
                this.hexWidth = tiledMap.getTileWidth();
                this.hexHeight = tiledMap.getSideLength() * 2 + this.sideOffsetY;
            }
        }
        this.quarterHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.25f));
        this.quarterHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.25f));
        this.halfHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.5f));
        this.halfHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.5f));
        this.threeQuarterHexWidth = MathUtils.round((float)((float)this.hexWidth * 0.75f));
        this.threeQuarterHexHeight = MathUtils.round((float)((float)this.hexHeight * 0.75f));
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        switch (this.tiledMap.getStaggerAxis()) {
            case X: {
                this.drawStaggeredXLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
                break;
            }
            default: {
                this.drawStaggeredYLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
            }
        }
    }

    private void drawStaggeredXLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        block3: for (int y = 0; y < heightInTiles; ++y) {
            switch (this.tiledMap.getStaggerIndex()) {
                case EVEN: {
                    int tileRenderY;
                    int tileRenderX;
                    int tileId;
                    int x;
                    int row1Offset = startTileX % 2 == 0 ? 1 : 0;
                    int row2Offset = startTileX % 2 == 0 ? 0 : 1;
                    for (x = row1Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY, alpha);
                    }
                    for (x = row2Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight + this.halfHexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY, alpha);
                    }
                    continue block3;
                }
                default: {
                    int tileRenderY;
                    int tileRenderX;
                    int tileId;
                    int x;
                    int row1Offset = startTileX % 2 == 0 ? 0 : 1;
                    int row2Offset = startTileX % 2 == 0 ? 1 : 0;
                    for (x = row1Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY, alpha);
                    }
                    for (x = row2Offset; x < widthInTiles; x += 2) {
                        tileId = layer.getTileId(x + startTileX, y + startTileY);
                        if (tileId < 1) continue;
                        tileRenderX = renderX + x * this.threeQuarterHexWidth;
                        tileRenderY = renderY + y * this.hexHeight + this.halfHexHeight;
                        this.renderTile(g, tileId, tileRenderX, tileRenderY, alpha);
                    }
                }
            }
        }
    }

    private void drawStaggeredYLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        for (int y = 0; y < heightInTiles; ++y) {
            int tileRenderY = renderY + y * this.threeQuarterHexHeight;
            for (int x = 0; x < widthInTiles; ++x) {
                int tileId = layer.getTileId(x + startTileX, y + startTileY);
                if (tileId < 1) continue;
                int tileRenderX = renderX + x * this.hexWidth;
                switch (this.tiledMap.getStaggerIndex()) {
                    case EVEN: {
                        if (y % 2 != 0) break;
                        tileRenderX += this.halfHexWidth;
                        break;
                    }
                    default: {
                        if (y % 2 != 1) break;
                        tileRenderX += this.halfHexWidth;
                    }
                }
                this.renderTile(g, tileId, tileRenderX, tileRenderY, alpha);
            }
        }
    }

    private void renderTile(Graphics g, int tileId, int tileRenderX, int tileRenderY, float alpha) {
        Tileset tileset = (Tileset)this.tileIdToTileset.get(tileId, null);
        if (tileset == null) {
            for (int i = 0; i < this.tiledMap.getTilesets().size; ++i) {
                Tileset searchTileset = (Tileset)this.tiledMap.getTilesets().get(i);
                if (!searchTileset.contains(tileId)) continue;
                tileset = searchTileset;
                this.tileIdToTileset.put(tileId, (Object)tileset);
                break;
            }
            if (tileset == null) {
                return;
            }
        }
        tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY, alpha);
    }

    @Override
    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HexagonalTileLayerRenderer that = (HexagonalTileLayerRenderer)o;
        return this.hexWidth == that.hexWidth && this.hexHeight == that.hexHeight && this.sideOffsetX == that.sideOffsetX && this.sideOffsetY == that.sideOffsetY && this.quarterHexWidth == that.quarterHexWidth && this.quarterHexHeight == that.quarterHexHeight && this.halfHexWidth == that.halfHexWidth && this.halfHexHeight == that.halfHexHeight && this.threeQuarterHexWidth == that.threeQuarterHexWidth && this.threeQuarterHexHeight == that.threeQuarterHexHeight;
    }

    public int hashCode() {
        return Objects.hash(this.hexWidth, this.hexHeight, this.sideOffsetX, this.sideOffsetY, this.quarterHexWidth, this.quarterHexHeight, this.halfHexWidth, this.halfHexHeight, this.threeQuarterHexWidth, this.threeQuarterHexHeight);
    }
}

