/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;
import org.mini2Dx.tiled.renderer.TiledMapRenderArea;

public class IsometricTileLayerRenderer
implements TileLayerRenderer {
    private TiledMapRenderArea mapClip;
    private TiledMapRenderArea tmpClip;
    private final TiledMap tiledMap;
    private final IntMap<Tileset> tileIdToTileset;
    private final float halfTileWidth;
    private final float halfTileHeight;

    public IsometricTileLayerRenderer(TiledMap tiledMap, IntMap<Tileset> tileIdToTileset) {
        this.tiledMap = tiledMap;
        this.tileIdToTileset = tileIdToTileset;
        this.halfTileWidth = (float)tiledMap.getTileWidth() * 0.5f;
        this.halfTileHeight = (float)tiledMap.getTileHeight() * 0.5f;
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        this.renderLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
    }

    private void renderLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        int totalRows = widthInTiles + heightInTiles;
        for (int row = 0; row < totalRows - 1; ++row) {
            int startX = this.getStartX(row, heightInTiles);
            int endY = this.getEndY(row, widthInTiles);
            int totalCols = this.getTotalCols(row, widthInTiles, heightInTiles);
            for (int col = 0; col < totalCols; ++col) {
                int relativeTileX = col + startX;
                int relativeTileY = totalCols - col - 1 + endY;
                int tileId = layer.getTileId(startTileX + relativeTileX, startTileY + relativeTileY);
                if (tileId < 1) continue;
                int tileRenderX = MathUtils.round((float)((float)renderX + (float)(relativeTileX - relativeTileY) * this.halfTileWidth));
                int tileRenderY = MathUtils.round((float)((float)renderY + (float)(relativeTileX + relativeTileY) * this.halfTileHeight));
                this.renderTile(g, alpha, tileId, tileRenderX, tileRenderY);
            }
        }
    }

    private boolean renderTile(Graphics g, float alpha, int tileId, int tileRenderX, int tileRenderY) {
        Tileset tileset = (Tileset)this.tileIdToTileset.get(tileId, null);
        if (tileset == null) {
            for (int i = 0; i < this.tiledMap.getTilesets().size; ++i) {
                Tileset searchTileset = (Tileset)this.tiledMap.getTilesets().get(i);
                if (!searchTileset.contains(tileId)) continue;
                tileset = searchTileset;
                this.tileIdToTileset.put(tileId, (Object)tileset);
                break;
            }
            if (tileset == null) {
                return true;
            }
        }
        tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY, alpha);
        return false;
    }

    private int getTotalCols(int row, int width, int height) {
        if (row < width && row < height) {
            return row + 1;
        }
        if (row >= height) {
            return width + height - row - 1;
        }
        return Math.min(width, height);
    }

    private int getStartX(int row, int height) {
        if (row < height) {
            return 0;
        }
        return row - height + 1;
    }

    private int getEndY(int row, int width) {
        if (row < width) {
            return 0;
        }
        return row - width + 1;
    }

    @Override
    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsometricTileLayerRenderer that = (IsometricTileLayerRenderer)o;
        return Float.compare(that.halfTileWidth, this.halfTileWidth) == 0 && Float.compare(that.halfTileHeight, this.halfTileHeight) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.halfTileWidth), Float.valueOf(this.halfTileHeight));
    }
}

