/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;

public class OrthogonalEmptyTileLayerRenderer
implements TileLayerRenderer {
    private static final int TILE_RENDER_REF_POOL_INITIAL_SIZE = 16384;
    private static final Queue<TileRenderRef> TILE_RENDER_REF_POOL = new Queue(16384);
    private final TiledMap tiledMap;
    private final TileLayer layer;
    private final Array<TileRenderRef> tiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrthogonalEmptyTileLayerRenderer(TiledMap tiledMap, TileLayer layer) {
        this.tiledMap = tiledMap;
        this.layer = layer;
        this.tiles = new Array(layer.getTotalFilledTiles() + 1);
        for (int y = 0; y < layer.getHeight(); ++y) {
            for (int x = 0; x < layer.getWidth(); ++x) {
                TileRenderRef ref;
                int tileId = layer.getTileId(x, y);
                if (tileId < 1) continue;
                Queue<TileRenderRef> queue = TILE_RENDER_REF_POOL;
                synchronized (queue) {
                    ref = OrthogonalEmptyTileLayerRenderer.TILE_RENDER_REF_POOL.size == 0 ? new TileRenderRef() : (TileRenderRef)TILE_RENDER_REF_POOL.removeFirst();
                }
                ref.x = x;
                ref.y = y;
                ref.tileId = tileId;
                this.tiles.add((Object)ref);
            }
        }
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        int startTileRenderX = startTileX * this.tiledMap.getTileWidth();
        int startTileRenderY = startTileY * this.tiledMap.getTileHeight();
        renderX = MathUtils.round((float)(renderX - startTileRenderX));
        renderY = MathUtils.round((float)(renderY - startTileRenderY));
        for (TileRenderRef tileRef : this.tiles) {
            if (tileRef.x < startTileX || tileRef.y < startTileY || tileRef.x >= startTileX + widthInTiles || tileRef.y >= startTileY + heightInTiles) continue;
            if (tileRef.tile == null) {
                for (int i = 0; i < this.tiledMap.getTilesets().size; ++i) {
                    Tileset tileset = (Tileset)this.tiledMap.getTilesets().get(i);
                    if (!tileset.contains(tileRef.tileId)) continue;
                    tileRef.tile = tileset.getTile(tileRef.tileId);
                    break;
                }
            }
            if (tileRef.tile == null) continue;
            boolean flipHorizontally = layer.isFlippedHorizontally(tileRef.x, tileRef.y);
            boolean flipVertically = layer.isFlippedVertically(tileRef.x, tileRef.y);
            boolean flipDiagonally = layer.isFlippedDiagonally(tileRef.x, tileRef.y);
            int tileRenderX = renderX + tileRef.x * this.tiledMap.getTileWidth();
            int tileRenderY = renderY + tileRef.y * this.tiledMap.getTileHeight();
            tileRef.tile.draw(g, tileRenderX, tileRenderY, alpha, flipHorizontally, flipVertically, flipDiagonally);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        for (int i = 0; i < this.tiles.size; ++i) {
            TileRenderRef renderRef = (TileRenderRef)this.tiles.get(i);
            renderRef.tile = null;
            Queue<TileRenderRef> queue = TILE_RENDER_REF_POOL;
            synchronized (queue) {
                TILE_RENDER_REF_POOL.addLast((Object)renderRef);
                continue;
            }
        }
        this.tiles.clear();
    }

    public TiledMap getTiledMap() {
        return this.tiledMap;
    }

    public TileLayer getLayer() {
        return this.layer;
    }

    static {
        for (int i = 0; i < 16384; ++i) {
            TILE_RENDER_REF_POOL.addLast((Object)new TileRenderRef());
        }
    }

    private static class TileRenderRef {
        public int x;
        public int y;
        public int tileId;
        public Tile tile;

        private TileRenderRef() {
        }
    }
}

