/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.tiled.Layer;
import org.mini2Dx.tiled.LayerType;
import org.mini2Dx.tiled.TileLayer;
import org.mini2Dx.tiled.TiledMap;
import org.mini2Dx.tiled.Tileset;
import org.mini2Dx.tiled.renderer.OrthogonalEmptyTileLayerRenderer;
import org.mini2Dx.tiled.renderer.TileLayerRenderer;

public class OrthogonalTileLayerRenderer
implements TileLayerRenderer {
    private final IntMap<Tileset> tileIdToTileset;
    private IntMap<OrthogonalEmptyTileLayerRenderer> emptyTileLayerRenderers;
    private final TiledMap tiledMap;
    private final Rectangle graphicsClip = new Rectangle();

    public OrthogonalTileLayerRenderer(TiledMap tiledMap, IntMap<Tileset> tileIdToTileset) {
        this.tiledMap = tiledMap;
        this.tileIdToTileset = tileIdToTileset;
        if (TiledMap.FAST_RENDER_EMPTY_LAYERS) {
            this.emptyTileLayerRenderers = new IntMap(tiledMap.getLayers().size + 1);
            for (Layer layer : tiledMap.getLayers()) {
                TileLayer tileLayer;
                if (!layer.getLayerType().equals((Object)LayerType.TILE) || !(tileLayer = tiledMap.getTileLayer(layer.getIndex())).isMostlyEmptyTiles()) continue;
                this.emptyTileLayerRenderers.put(tileLayer.getIndex(), (Object)new OrthogonalEmptyTileLayerRenderer(tiledMap, tileLayer));
            }
        }
    }

    @Override
    public void drawLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        OrthogonalEmptyTileLayerRenderer renderer;
        if (TiledMap.FAST_RENDER_EMPTY_LAYERS && this.emptyTileLayerRenderers != null && (renderer = (OrthogonalEmptyTileLayerRenderer)this.emptyTileLayerRenderers.get(layer.getIndex(), null)) != null) {
            renderer.drawLayer(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
            return;
        }
        this.renderWithoutClipAndTranslate(g, layer, renderX, renderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
    }

    private void renderWithoutClipAndTranslate(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        int startTileRenderX = startTileX * this.tiledMap.getTileWidth();
        int startTileRenderY = startTileY * this.tiledMap.getTileHeight();
        int tileRenderX = MathUtils.round((float)(renderX - startTileRenderX));
        int tileRenderY = MathUtils.round((float)(renderY - startTileRenderY));
        this.renderLayer(g, layer, tileRenderX, tileRenderY, startTileX, startTileY, widthInTiles, heightInTiles, alpha);
    }

    private void renderLayer(Graphics g, TileLayer layer, int renderX, int renderY, int startTileX, int startTileY, int widthInTiles, int heightInTiles, float alpha) {
        for (int y = startTileY; y < startTileY + heightInTiles && y < layer.getHeight(); ++y) {
            for (int x = startTileX; x < startTileX + widthInTiles && x < layer.getWidth(); ++x) {
                int tileId = layer.getTileId(x, y);
                if (tileId < 1) continue;
                boolean flipHorizontally = layer.isFlippedHorizontally(x, y);
                boolean flipVertically = layer.isFlippedVertically(x, y);
                boolean flipDiagonally = layer.isFlippedDiagonally(x, y);
                int tileRenderX = renderX + x * this.tiledMap.getTileWidth();
                int tileRenderY = renderY + y * this.tiledMap.getTileHeight();
                if (TiledMap.CLIP_TILES_OUTSIDE_GRAPHICS_VIEWPORT && ((float)(tileRenderX + this.tiledMap.getTileWidth()) < g.getTranslationX() || (float)(tileRenderY + this.tiledMap.getTileHeight()) < g.getTranslationY() || (float)tileRenderX > g.getTranslationX() + g.getViewportWidth() || (float)tileRenderY > g.getTranslationY() + g.getViewportHeight())) continue;
                this.renderTile(g, alpha, tileId, flipHorizontally, flipVertically, flipDiagonally, tileRenderX, tileRenderY);
            }
        }
    }

    private void renderTile(Graphics g, float alpha, int tileId, boolean flipHorizontally, boolean flipVertically, boolean flipDiagonally, int tileRenderX, int tileRenderY) {
        Tileset tileset = (Tileset)this.tileIdToTileset.get(tileId, null);
        if (tileset == null) {
            for (int i = 0; i < this.tiledMap.getTilesets().size; ++i) {
                Tileset searchTileset = (Tileset)this.tiledMap.getTilesets().get(i);
                if (!searchTileset.contains(tileId)) continue;
                tileset = searchTileset;
                this.tileIdToTileset.put(tileId, (Object)tileset);
                break;
            }
            if (tileset == null) {
                return;
            }
        }
        tileset.getTile(tileId).draw(g, tileRenderX, tileRenderY, alpha, flipHorizontally, flipVertically, flipDiagonally);
    }

    @Override
    public void dispose() {
        if (this.emptyTileLayerRenderers != null) {
            for (OrthogonalEmptyTileLayerRenderer renderer : this.emptyTileLayerRenderers.values()) {
                renderer.dispose();
            }
            this.emptyTileLayerRenderers.clear();
            this.emptyTileLayerRenderers = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }
}

