/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.renderer.TileRenderer;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class StaticTileRenderer
implements TileRenderer {
    public static final int RENDERER_TYPE = 0;
    private static final ObjectMap<TilesetSource, StaticTileRenderer> RENDERERS = new ObjectMap();
    private final TilesetSource tilesetSource;

    private StaticTileRenderer(TilesetSource tilesetSource) {
        this.tilesetSource = tilesetSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StaticTileRenderer create(TilesetSource tilesetSource) {
        ObjectMap<TilesetSource, StaticTileRenderer> objectMap = RENDERERS;
        synchronized (objectMap) {
            if (!RENDERERS.containsKey((Object)tilesetSource)) {
                RENDERERS.put((Object)tilesetSource, (Object)new StaticTileRenderer(tilesetSource));
            }
            return (StaticTileRenderer)RENDERERS.get((Object)tilesetSource);
        }
    }

    public static StaticTileRenderer fromInputStream(TilesetSource tilesetSource, Tile tile) {
        return StaticTileRenderer.create(tilesetSource);
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
    }

    public void readData(DataInputStream inputStream) throws IOException {
    }

    @Override
    public void update(Tile tile, float delta) {
    }

    @Override
    public void draw(Graphics g, Tile tile, int renderX, int renderY, float alpha) {
        Sprite tileImage = this.getCurrentTileImage(tile);
        tileImage.setAlpha(alpha);
        tileImage.setPosition((float)renderX, (float)renderY);
        g.drawSprite(tileImage);
    }

    @Override
    public void draw(Graphics g, Tile tile, int renderX, int renderY, float alpha, boolean flipH, boolean flipV, boolean flipD) {
        StaticTileRenderer.drawTileImage(g, this.getCurrentTileImage(tile), renderX, renderY, alpha, flipH, flipV, flipD);
    }

    @Override
    public Sprite getCurrentTileImage(Tile tile) {
        return this.tilesetSource.getTileImage(tile.getTileId(0));
    }

    public void dispose() {
    }

    public static void drawTileImage(Graphics g, Sprite tileImage, int renderX, int renderY, float alpha, boolean flipH, boolean flipV, boolean flipD) {
        if (tileImage == null) {
            return;
        }
        boolean previousFlipX = tileImage.isFlipX();
        boolean previousFlipY = tileImage.isFlipY();
        if (flipD) {
            if (flipH && flipV) {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(true, previousFlipY);
            } else if (flipH) {
                tileImage.setRotation(90.0f);
            } else if (flipV) {
                tileImage.setRotation(270.0f);
            } else {
                tileImage.setRotation(90.0f);
                tileImage.setFlip(previousFlipX, true);
            }
        } else {
            tileImage.setFlip(flipH, flipV);
        }
        tileImage.setAlpha(alpha);
        tileImage.setPosition((float)renderX, (float)renderY);
        g.drawSprite(tileImage);
        tileImage.setRotation(0.0f);
        tileImage.setFlip(previousFlipX, previousFlipY);
    }

    @Override
    public int getRendererType() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }
}

