/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.renderer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.serialization.GameDataSerializable;

public class TileFrame
implements GameDataSerializable {
    float duration;
    int tileId;

    public TileFrame(float duration, int tileId) {
        this.duration = duration;
        this.tileId = tileId;
    }

    private TileFrame() {
    }

    public static TileFrame fromInputStream(DataInputStream inputStream) throws IOException {
        TileFrame result = new TileFrame();
        result.readData(inputStream);
        return result;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getTileId() {
        return this.tileId;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeFloat(this.duration);
        outputStream.writeInt(this.tileId);
    }

    public void readData(DataInputStream inputStream) throws IOException {
        this.duration = inputStream.readFloat();
        this.tileId = inputStream.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileFrame tileFrame = (TileFrame)o;
        return Float.compare(tileFrame.duration, this.duration) == 0 && this.tileId == tileFrame.tileId;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.duration), this.tileId);
    }
}

