/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.tileset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.PixmapFormat;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.graphics.TextureAtlasRegion;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.core.serialization.GameDataSerializableUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.renderer.AnimatedTileRenderer;
import org.mini2Dx.tiled.renderer.StaticTileRenderer;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class ImageTilesetSource
extends TilesetSource {
    public static final int TILESET_TYPE = 0;
    private Tile[][] tiles;
    private IntMap<Sprite> tileImages = new IntMap();
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int spacing;
    private int margin;
    private String name;
    private String tilesetImagePath;
    private String transparentColorValue;
    private ObjectMap<String, String> properties;
    private int widthInTiles;
    private int heightInTiles;
    private Texture backingTexture;
    private TextureRegion textureRegion;

    public ImageTilesetSource(int width, int height, int tileWidth, int tileHeight, int spacing, int margin) {
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.spacing = spacing;
        this.margin = margin;
        this.widthInTiles = -1;
        this.heightInTiles = -1;
        this.tiles = new Tile[this.getWidthInTiles()][this.getHeightInTiles()];
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                this.tiles[x][y] = Tile.create();
                this.tiles[x][y].setTileId(this.getTileId(x, y, 0));
            }
        }
    }

    private ImageTilesetSource() {
    }

    public static ImageTilesetSource fromInputStream(DataInputStream inputStream) throws IOException {
        ImageTilesetSource result = new ImageTilesetSource();
        result.readData(inputStream);
        return result;
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        int x;
        outputStream.writeInt(this.width);
        outputStream.writeInt(this.height);
        outputStream.writeInt(this.tileWidth);
        outputStream.writeInt(this.tileHeight);
        outputStream.writeInt(this.spacing);
        outputStream.writeInt(this.margin);
        GameDataSerializableUtils.writeString((String)this.name, (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)this.tilesetImagePath, (DataOutputStream)outputStream);
        GameDataSerializableUtils.writeString((String)this.transparentColorValue, (DataOutputStream)outputStream);
        outputStream.writeInt(this.properties == null ? 0 : this.properties.size);
        if (this.properties != null) {
            for (String key : this.properties.keys()) {
                outputStream.writeUTF(key);
                GameDataSerializableUtils.writeString((String)((String)this.properties.get((Object)key, null)), (DataOutputStream)outputStream);
            }
        }
        for (x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                this.tiles[x][y].writeData(outputStream);
            }
        }
        for (x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                outputStream.writeInt(this.tiles[x][y].getTileRenderer().getRendererType());
                this.tiles[x][y].getTileRenderer().writeData(outputStream);
            }
        }
    }

    public void readData(DataInputStream inputStream) throws IOException {
        int x;
        this.width = inputStream.readInt();
        this.height = inputStream.readInt();
        this.tileWidth = inputStream.readInt();
        this.tileHeight = inputStream.readInt();
        this.spacing = inputStream.readInt();
        this.margin = inputStream.readInt();
        this.name = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.tilesetImagePath = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        this.transparentColorValue = GameDataSerializableUtils.readString((DataInputStream)inputStream);
        int totalProperties = inputStream.readInt();
        if (totalProperties > 0) {
            this.properties = new ObjectMap();
            for (int i = 0; i < totalProperties; ++i) {
                String key = inputStream.readUTF();
                String value = GameDataSerializableUtils.readString((DataInputStream)inputStream);
                this.properties.put((Object)key, (Object)value);
            }
        }
        this.widthInTiles = -1;
        this.heightInTiles = -1;
        this.tiles = new Tile[this.getWidthInTiles()][this.getHeightInTiles()];
        for (x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                this.tiles[x][y] = Tile.create();
                this.tiles[x][y].readData(inputStream);
            }
        }
        for (x = 0; x < this.getWidthInTiles(); ++x) {
            block7: for (int y = 0; y < this.getHeightInTiles(); ++y) {
                int rendererType = inputStream.readInt();
                switch (rendererType) {
                    case 1: {
                        this.tiles[x][y].setTileRenderer(AnimatedTileRenderer.fromInputStream(this, inputStream));
                        continue block7;
                    }
                    default: {
                        this.tiles[x][y].setTileRenderer(StaticTileRenderer.fromInputStream(this, this.tiles[x][y]));
                    }
                }
            }
        }
    }

    private Texture modifyPixmapWithTransparentColor(Pixmap pixmap) {
        float r = (float)Integer.parseInt(this.transparentColorValue.substring(0, 2), 16) / 255.0f;
        float g = (float)Integer.parseInt(this.transparentColorValue.substring(2, 4), 16) / 255.0f;
        float b = (float)Integer.parseInt(this.transparentColorValue.substring(4, 6), 16) / 155.0f;
        Color transparentColor = Mdx.graphics.newColor(r, g, b, 1.0f);
        Pixmap updatedPixmap = Mdx.graphics.newPixmap(pixmap.getWidth(), pixmap.getHeight(), PixmapFormat.RGBA8888);
        IntMap colorCache = new IntMap();
        for (int x = 0; x < pixmap.getWidth(); ++x) {
            for (int y = 0; y < pixmap.getHeight(); ++y) {
                Color pixelColor;
                int pixelRGBA8888 = pixmap.getPixel(x, y);
                if (colorCache.containsKey(pixelRGBA8888)) {
                    pixelColor = (Color)colorCache.get(pixelRGBA8888);
                } else {
                    pixelColor = Mdx.graphics.newColor(pixelRGBA8888);
                    colorCache.put(pixelRGBA8888, (Object)pixelColor);
                }
                if (transparentColor.equals(pixelColor)) continue;
                updatedPixmap.drawPixel(x, y, pixelColor);
            }
        }
        colorCache.clear();
        Texture result = Mdx.graphics.newTexture(updatedPixmap);
        updatedPixmap.dispose();
        pixmap.dispose();
        return result;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(FileHandle tmxPath) {
        Array dependencies = new Array();
        dependencies.add((Object)new AssetDescriptor(this.tilesetImagePath, Pixmap.class));
        return dependencies;
    }

    @Override
    public void loadTexture(FileHandle tmxPath) {
        if (this.textureRegion != null) {
            return;
        }
        switch (tmxPath.type()) {
            case INTERNAL: {
                this.loadTileImages(Mdx.graphics.newPixmap(Mdx.files.internal(this.tilesetImagePath)));
                break;
            }
            case EXTERNAL: {
                this.loadTileImages(Mdx.graphics.newPixmap(Mdx.files.external(this.tilesetImagePath)));
                break;
            }
            case LOCAL: {
                this.loadTileImages(Mdx.graphics.newPixmap(Mdx.files.local(this.tilesetImagePath)));
            }
        }
    }

    @Override
    public void loadTexture(AssetManager assetManager, FileHandle tmxPath) {
        if (this.textureRegion != null) {
            return;
        }
        this.loadTileImages((Pixmap)assetManager.get(this.tilesetImagePath, Pixmap.class));
    }

    @Override
    public void loadTexture(TextureAtlas textureAtlas) {
        if (this.textureRegion != null) {
            return;
        }
        TextureAtlasRegion atlasRegion = textureAtlas.findRegion(this.tilesetImagePath);
        if (atlasRegion == null && this.tilesetImagePath.lastIndexOf(46) > -1) {
            TextureAtlasRegion textureAtlasRegion = textureAtlas.findRegion(this.tilesetImagePath.substring(0, this.tilesetImagePath.lastIndexOf(46)));
            if (textureAtlasRegion == null) {
                throw new MdxException("Could not resolve " + this.tilesetImagePath + " tileset");
            }
            this.loadTileImages(Mdx.graphics.newTextureRegion((TextureRegion)textureAtlasRegion));
        } else {
            this.loadTileImages(Mdx.graphics.newTextureRegion((TextureRegion)atlasRegion));
        }
    }

    private void loadTileImages(TextureRegion textureRegion) {
        if (this.transparentColorValue != null) {
            this.backingTexture = this.modifyPixmapWithTransparentColor(textureRegion.toPixmap());
            this.textureRegion = Mdx.graphics.newTextureRegion(this.backingTexture);
        } else {
            this.textureRegion = textureRegion;
        }
        this.cutTiles();
    }

    private void loadTileImages(Pixmap pixmap) {
        if (this.transparentColorValue != null) {
            this.backingTexture = this.modifyPixmapWithTransparentColor(pixmap);
            this.textureRegion = Mdx.graphics.newTextureRegion(this.backingTexture);
        } else {
            this.backingTexture = Mdx.graphics.newTexture(pixmap);
            this.textureRegion = Mdx.graphics.newTextureRegion(this.backingTexture);
            pixmap.dispose();
        }
        this.cutTiles();
    }

    private void cutTiles() {
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                int tileX = this.margin + x * this.spacing + x * this.tileWidth;
                int tileY = this.margin + y * this.spacing + y * this.tileHeight;
                Sprite tileImage = Mdx.graphics.newSprite(this.textureRegion, tileX, tileY, this.tileWidth, this.tileHeight);
                this.tileImages.put(this.tiles[x][y].getTileId(0), (Object)tileImage);
            }
        }
    }

    @Override
    public boolean isTextureLoaded() {
        return this.textureRegion != null;
    }

    @Override
    public Sprite getTileImage(int tileId) {
        return (Sprite)this.tileImages.get(tileId);
    }

    @Override
    public int getWidthInTiles() {
        if (this.widthInTiles < 0) {
            int result = 0;
            for (int x = this.margin; x <= this.width - this.tileWidth; x += this.tileWidth + this.spacing) {
                ++result;
            }
            this.widthInTiles = result;
        }
        return this.widthInTiles;
    }

    @Override
    public int getHeightInTiles() {
        if (this.heightInTiles < 0) {
            int result = 0;
            for (int y = this.margin; y <= this.height - this.tileHeight; y += this.tileHeight + this.spacing) {
                ++result;
            }
            this.heightInTiles = result;
        }
        return this.heightInTiles;
    }

    @Override
    public Tile getTileByPosition(int x, int y) {
        return this.tiles[x][y];
    }

    @Override
    public Tile getTile(int tileId, int firstGid) {
        int tileX = this.getTileX(tileId, firstGid);
        int tileY = this.getTileY(tileId, firstGid);
        return this.tiles[tileX][tileY];
    }

    @Override
    public void drawTile(Graphics g, int tileId, int firstGid, int renderX, int renderY, float alpha) {
        int tileX = this.getTileX(tileId, firstGid);
        int tileY = this.getTileY(tileId, firstGid);
        this.tiles[tileX][tileY].draw(g, renderX, renderY, alpha);
    }

    @Override
    public void drawTileset(Graphics g, int renderX, int renderY, float alpha) {
        for (int y = 0; y < this.getHeightInTiles(); ++y) {
            for (int x = 0; x < this.getWidthInTiles(); ++x) {
                this.tiles[x][y].draw(g, renderX + x * this.getTileWidth(), renderY + y * this.getTileHeight(), alpha);
            }
        }
    }

    @Override
    public boolean containsProperty(String propertyName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey((Object)propertyName);
    }

    @Override
    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)propertyName);
    }

    @Override
    public void setProperty(String propertyName, String value) {
        if (this.properties == null) {
            this.properties = new ObjectMap();
        }
        this.properties.put((Object)propertyName, (Object)value);
    }

    @Override
    public ObjectMap<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public int getMargin() {
        return this.margin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getInternalUuid() {
        return this.tilesetImagePath;
    }

    @Override
    public int getTilesetSourceType() {
        return 0;
    }

    public String getTilesetImagePath() {
        return this.tilesetImagePath;
    }

    public void setTilesetImagePath(String tilesetImagePath) {
        this.tilesetImagePath = tilesetImagePath;
    }

    public String getTransparentColorValue() {
        return this.transparentColorValue;
    }

    public void setTransparentColorValue(String transparentColorValue) {
        this.transparentColorValue = transparentColorValue;
    }

    public void dispose() {
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                if (this.tiles[x][y] == null) continue;
                this.tiles[x][y].dispose();
                this.tiles[x][y] = null;
            }
        }
        this.textureRegion = null;
        if (this.backingTexture == null) {
            return;
        }
        this.backingTexture.dispose();
        this.backingTexture = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageTilesetSource that = (ImageTilesetSource)o;
        return Objects.equals(this.tilesetImagePath, that.tilesetImagePath);
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.tileWidth;
        result = 31 * result + this.tileHeight;
        result = 31 * result + this.spacing;
        result = 31 * result + this.margin;
        result = 31 * result + (this.tilesetImagePath != null ? this.tilesetImagePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder tilesStr = new StringBuilder();
        tilesStr.append("[");
        for (int x = 0; x < this.getWidthInTiles(); ++x) {
            for (int y = 0; y < this.getHeightInTiles(); ++y) {
                if (this.tiles[x][y] == null) {
                    tilesStr.append("null");
                } else {
                    tilesStr.append(this.tiles[x][y]);
                }
                tilesStr.append(' ');
            }
        }
        tilesStr.append("]");
        return "ImageTilesetSource{tiles=" + tilesStr.toString() + ", width=" + this.width + ", height=" + this.height + ", tileWidth=" + this.tileWidth + ", tileHeight=" + this.tileHeight + ", spacing=" + this.spacing + ", margin=" + this.margin + ", name='" + this.name + '\'' + ", tilesetImagePath='" + this.tilesetImagePath + '\'' + ", transparentColorValue='" + this.transparentColorValue + '\'' + ", properties=" + this.properties + "} " + super.toString();
    }
}

