/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.tileset;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.serialization.GameDataSerializable;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.Tile;

public abstract class TilesetSource
implements GameDataSerializable,
Disposable {
    public int getTileId(int x, int y, int firstGid) {
        return firstGid + y * this.getWidthInTiles() + x;
    }

    public int getTileX(int tileId, int firstGid) {
        return (tileId - firstGid) % this.getWidthInTiles();
    }

    public int getTileY(int tileId, int firstGid) {
        return (tileId - firstGid) / this.getWidthInTiles();
    }

    public boolean contains(int tileId, int firstGid, int lastGid) {
        return tileId >= firstGid && tileId <= lastGid;
    }

    public abstract Array<AssetDescriptor> getDependencies(FileHandle var1);

    public abstract void loadTexture(FileHandle var1);

    public abstract void loadTexture(AssetManager var1, FileHandle var2);

    public abstract void loadTexture(TextureAtlas var1);

    public abstract boolean isTextureLoaded();

    public abstract Sprite getTileImage(int var1);

    public Sprite getTileImage(int tileId, int firstGid) {
        return this.getTileImage(tileId - firstGid);
    }

    public abstract void drawTile(Graphics var1, int var2, int var3, int var4, int var5, float var6);

    public abstract void drawTileset(Graphics var1, int var2, int var3, float var4);

    public abstract Tile getTile(int var1, int var2);

    public abstract Tile getTileByPosition(int var1, int var2);

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getTileWidth();

    public abstract int getTileHeight();

    public abstract int getWidthInTiles();

    public abstract int getHeightInTiles();

    public abstract int getSpacing();

    public abstract int getMargin();

    public abstract boolean containsProperty(String var1);

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public abstract ObjectMap<String, String> getProperties();

    public abstract String getInternalUuid();

    public abstract int getTilesetSourceType();

    public boolean equals(Object obj) {
        if (obj instanceof TilesetSource) {
            TilesetSource otherSource = (TilesetSource)obj;
            return this.getInternalUuid().equals(otherSource.getInternalUuid());
        }
        return super.equals(obj);
    }
}

