/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.tiled.tileset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetDescriptor;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectMap;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.tiled.Tile;
import org.mini2Dx.tiled.TiledMapData;
import org.mini2Dx.tiled.TiledParser;
import org.mini2Dx.tiled.tileset.ImageTilesetSource;
import org.mini2Dx.tiled.tileset.TilesetSource;

public class TsxTilesetSource
extends TilesetSource {
    private static final String LOGGING_TAG = TsxTilesetSource.class.getSimpleName();
    public static final int TILESET_TYPE = 1;
    private static final ConcurrentObjectMap<String, ImageTilesetSource> TILESETS = new ConcurrentObjectMap();
    private static final ConcurrentObjectMap<String, AtomicInteger> TILESET_REFS = new ConcurrentObjectMap();
    private final ImageTilesetSource tileset;
    private String tsxPath;

    public TsxTilesetSource(FileHandle tmxPath, String tsxPath) {
        FileHandle tsxFileHandle = tmxPath.sibling(tsxPath).normalizedHandle();
        this.tsxPath = tsxFileHandle.path();
        if (!TILESETS.containsKey((Object)this.tsxPath)) {
            try {
                TiledParser tiledParser = new TiledParser();
                TILESETS.putIfAbsent((Object)this.tsxPath, (Object)tiledParser.parseTsx(tsxFileHandle));
            }
            catch (IOException e) {
                Mdx.log.error(LOGGING_TAG, "Could not parse " + tsxPath + ". " + e.getMessage(), (Exception)e);
                TILESETS.putIfAbsent((Object)this.tsxPath, null);
            }
        }
        if (!TILESET_REFS.containsKey((Object)this.tsxPath)) {
            TILESET_REFS.putIfAbsent((Object)this.tsxPath, (Object)new AtomicInteger(0));
        }
        this.tileset = (ImageTilesetSource)TILESETS.get((Object)this.tsxPath);
        ((AtomicInteger)TILESET_REFS.get((Object)this.tsxPath)).incrementAndGet();
    }

    private TsxTilesetSource(TiledMapData tiledMapData, String tsxPath) {
        FileHandle tsxFileHandle;
        this.tsxPath = tsxPath;
        switch (tiledMapData.getFileHandle().type()) {
            default: {
                tsxFileHandle = Mdx.files.internal(tsxPath);
                break;
            }
            case EXTERNAL: {
                tsxFileHandle = Mdx.files.external(tsxPath);
                break;
            }
            case LOCAL: {
                tsxFileHandle = Mdx.files.local(tsxPath);
            }
        }
        if (!TILESETS.containsKey((Object)this.tsxPath)) {
            try {
                TiledParser tiledParser = new TiledParser();
                TILESETS.putIfAbsent((Object)this.tsxPath, (Object)tiledParser.parseTsx(tsxFileHandle));
            }
            catch (IOException e) {
                Mdx.log.error(LOGGING_TAG, "Could not parse " + tsxPath + ". " + e.getMessage(), (Exception)e);
                TILESETS.putIfAbsent((Object)this.tsxPath, null);
            }
        }
        if (!TILESET_REFS.containsKey((Object)this.tsxPath)) {
            TILESET_REFS.putIfAbsent((Object)this.tsxPath, (Object)new AtomicInteger(0));
        }
        this.tileset = (ImageTilesetSource)TILESETS.get((Object)this.tsxPath);
        ((AtomicInteger)TILESET_REFS.get((Object)this.tsxPath)).incrementAndGet();
    }

    public static TsxTilesetSource fromInputStream(TiledMapData tiledMapData, DataInputStream inputStream) throws IOException {
        String tsxPath = inputStream.readUTF();
        return new TsxTilesetSource(tiledMapData, tsxPath);
    }

    public void writeData(DataOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.tsxPath);
    }

    public void readData(DataInputStream inputStream) throws IOException {
    }

    @Override
    public Array<AssetDescriptor> getDependencies(FileHandle tmxPath) {
        return this.tileset.getDependencies(tmxPath);
    }

    @Override
    public void loadTexture(FileHandle tmxPath) {
        this.tileset.loadTexture(tmxPath);
    }

    @Override
    public void loadTexture(AssetManager assetManager, FileHandle tmxPath) {
        this.tileset.loadTexture(assetManager, tmxPath);
    }

    @Override
    public void loadTexture(TextureAtlas textureAtlas) {
        this.tileset.loadTexture(textureAtlas);
    }

    @Override
    public boolean isTextureLoaded() {
        return this.tileset.isTextureLoaded();
    }

    @Override
    public Sprite getTileImage(int tileId) {
        return this.tileset.getTileImage(tileId);
    }

    @Override
    public int getWidthInTiles() {
        return this.tileset.getWidthInTiles();
    }

    @Override
    public int getHeightInTiles() {
        return this.tileset.getHeightInTiles();
    }

    @Override
    public void drawTile(Graphics g, int tileId, int firstGid, int renderX, int renderY, float alpha) {
        this.tileset.drawTile(g, tileId, firstGid, renderX, renderY, alpha);
    }

    @Override
    public void drawTileset(Graphics g, int renderX, int renderY, float alpha) {
        this.tileset.drawTileset(g, renderX, renderY, alpha);
    }

    @Override
    public int getWidth() {
        return this.tileset.getWidth();
    }

    @Override
    public int getHeight() {
        return this.tileset.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.tileset.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.tileset.getTileHeight();
    }

    @Override
    public int getSpacing() {
        return this.tileset.getSpacing();
    }

    @Override
    public int getMargin() {
        return this.tileset.getMargin();
    }

    @Override
    public Tile getTileByPosition(int x, int y) {
        return this.tileset.getTileByPosition(x, y);
    }

    @Override
    public Tile getTile(int tileId, int firstGid) {
        return this.tileset.getTile(tileId, firstGid);
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.tileset.containsProperty(propertyName);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.tileset.getProperty(propertyName);
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.tileset.setProperty(propertyName, value);
    }

    @Override
    public ObjectMap<String, String> getProperties() {
        return this.tileset.getProperties();
    }

    @Override
    public String getInternalUuid() {
        return this.getTsxPath();
    }

    @Override
    public int getTilesetSourceType() {
        return 1;
    }

    public ImageTilesetSource getTileset() {
        return this.tileset;
    }

    public String getTsxPath() {
        return this.tsxPath;
    }

    public void setTsxPath(String tsxPath) {
        this.tsxPath = tsxPath;
    }

    public void dispose() {
        int remainingRefs = ((AtomicInteger)TILESET_REFS.get((Object)this.tsxPath)).decrementAndGet();
        if (remainingRefs > 0) {
            return;
        }
        ImageTilesetSource tilesetSource = (ImageTilesetSource)TILESETS.remove((Object)this.tsxPath);
        if (tilesetSource == null) {
            return;
        }
        tilesetSource.dispose();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsxTilesetSource that = (TsxTilesetSource)o;
        return Objects.equals(this.tsxPath, that.tsxPath) && Objects.equals(this.tileset, that.tileset);
    }

    public int hashCode() {
        return Objects.hash(this.tsxPath, this.tileset);
    }
}

