/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.lua;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.mini2Dx.miniscript.core.ClasspathScriptProvider;
import org.mini2Dx.miniscript.core.GameScriptingEngine;
import org.mini2Dx.miniscript.core.GeneratedClasspathScriptProvider;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionResult;
import org.mini2Dx.miniscript.core.ScriptExecutionTask;
import org.mini2Dx.miniscript.core.ScriptInvocationListener;
import org.mini2Dx.miniscript.core.dummy.DummyGameScriptingEngine;
import org.mini2Dx.miniscript.lua.LuaScriptExecutorPool;

public class LuaScriptExecutorPoolTest
implements ScriptInvocationListener {
    @Test
    public void testScriptIds() {
        DummyGameScriptingEngine dummyGameScriptingEngine = new DummyGameScriptingEngine();
        GeneratedClasspathScriptProvider classpathScriptProvider = new GeneratedClasspathScriptProvider(){

            public Map getGeneratedScripts() {
                HashMap<String, LuaValue> results = new HashMap<String, LuaValue>();
                results.put("script1", JsePlatform.standardGlobals().load("print(\"script1\")"));
                results.put("script2", JsePlatform.standardGlobals().load("print(\"script2\")"));
                results.put("script3", JsePlatform.standardGlobals().load("print(\"script3\")"));
                results.put("script4", JsePlatform.standardGlobals().load("print(\"script4\")"));
                return results;
            }
        };
        LuaScriptExecutorPool luaScriptExecutorPool = new LuaScriptExecutorPool((GameScriptingEngine)dummyGameScriptingEngine, (ClasspathScriptProvider)classpathScriptProvider, 4, false);
        ScriptBindings scriptBindings = new ScriptBindings();
        ScriptExecutionTask scriptExecutionTask = luaScriptExecutorPool.execute(0, 0, scriptBindings, (ScriptInvocationListener)this, true);
        Assert.assertEquals((long)0L, (long)scriptExecutionTask.getScriptId());
        scriptExecutionTask = luaScriptExecutorPool.execute(1, 1, scriptBindings, (ScriptInvocationListener)this, true);
        Assert.assertEquals((long)1L, (long)scriptExecutionTask.getScriptId());
        scriptExecutionTask = luaScriptExecutorPool.execute(2, 2, scriptBindings, (ScriptInvocationListener)this, true);
        Assert.assertEquals((long)2L, (long)scriptExecutionTask.getScriptId());
        scriptExecutionTask = luaScriptExecutorPool.execute(2, 3, scriptBindings, (ScriptInvocationListener)this, true);
        Assert.assertEquals((long)3L, (long)scriptExecutionTask.getScriptId());
    }

    public void onScriptSuccess(int scriptId, ScriptExecutionResult executionResult) {
    }

    public void onScriptSkipped(int scriptId) {
    }

    public void onScriptException(int scriptId, Exception e) {
    }

    public boolean callOnGameThread() {
        return false;
    }
}

