/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd;

import java.sql.Connection;
import java.util.List;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.impl.dbutil.SdDbUtilDB2Impl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilMySqlImpl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilOracleImpl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilPostgreSqlImpl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilSqlServerImpl;
import org.mirrentools.sd.impl.dbutil.SdDbUtilSqliteImpl;
import org.mirrentools.sd.models.db.query.SdTable;
import org.mirrentools.sd.models.db.query.SdTableAttribute;
import org.mirrentools.sd.models.db.query.SdTableColumnAttribute;
import org.mirrentools.sd.models.db.query.SdTableIndexKeyAttribute;
import org.mirrentools.sd.models.db.query.SdTablePortedKeysAttribute;
import org.mirrentools.sd.models.db.query.SdTablePrimaryKeyAttribute;
import org.mirrentools.sd.models.db.update.SdAbstractDatabaseContent;
import org.mirrentools.sd.models.db.update.SdAbstractTableContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public abstract class ScrewDriverDbUtil {
    public static ScrewDriverDbUtil instance(SdDatabaseOptions databaseOptions) {
        String groupId = databaseOptions.getDriverClass();
        if (groupId.contains("mysql")) {
            return new SdDbUtilMySqlImpl(databaseOptions);
        }
        if (groupId.contains("postgresql")) {
            return new SdDbUtilPostgreSqlImpl(databaseOptions);
        }
        if (groupId.contains("db2")) {
            return new SdDbUtilDB2Impl(databaseOptions);
        }
        if (groupId.contains("oracle")) {
            return new SdDbUtilOracleImpl(databaseOptions);
        }
        if (groupId.contains("sqlserver")) {
            return new SdDbUtilSqlServerImpl(databaseOptions);
        }
        if (groupId.contains("sqlite")) {
            return new SdDbUtilSqliteImpl(databaseOptions);
        }
        throw new ScrewDriverException("Unable to recognize database types through DriverClass,You can extends the SdAbstractDbUtil class and init it");
    }

    public abstract Connection getConnection() throws Exception;

    public abstract Connection getConnection(SdDatabaseOptions var1) throws Exception;

    public abstract boolean existDatabase(String var1) throws Exception;

    public abstract boolean existDatabase(SdDatabaseOptions var1, String var2) throws Exception;

    public abstract boolean existTable(String var1) throws Exception;

    public abstract boolean createDatabase(SdAbstractDatabaseContent var1) throws Exception;

    public abstract boolean createDatabase(SdDatabaseOptions var1, SdAbstractDatabaseContent var2) throws Exception;

    public abstract boolean updateDatabase(SdAbstractDatabaseContent var1) throws Exception;

    public abstract boolean updateDatabase(SdDatabaseOptions var1, SdAbstractDatabaseContent var2) throws Exception;

    public abstract boolean createTable(SdAbstractTableContent var1) throws Exception;

    public abstract boolean updateTable(SdAbstractTableContent var1) throws Exception;

    public abstract boolean deleteTable(SdAbstractTableContent var1) throws Exception;

    public abstract SdTable getSdTable(String var1) throws Exception;

    public abstract SdTable getSdTable(String var1, boolean var2, boolean var3) throws Exception;

    public abstract List<String> getTableNames() throws Exception;

    public abstract SdTableAttribute getTableAttribute(String var1) throws Exception;

    public abstract List<SdTableColumnAttribute> getTableColumnsAttribute(String var1) throws Exception;

    public abstract SdTablePrimaryKeyAttribute getTablePrimaryKeyAttribute(String var1) throws Exception;

    public abstract List<SdTableIndexKeyAttribute> getTableIndexKeysAttribute(String var1, boolean var2, boolean var3) throws Exception;

    public abstract List<SdTablePortedKeysAttribute> getTableExportedKeysAttribute(String var1) throws Exception;

    public abstract List<SdTablePortedKeysAttribute> getTableImportedKeysAttribute(String var1) throws Exception;
}

