/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.converter;

import java.util.Set;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdClassConverter;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdColumn;
import org.mirrentools.sd.models.SdRelational;
import org.mirrentools.sd.models.SdRelationalContent;

public abstract class SdAbstractClassConverter
implements SdClassConverter {
    private int defaltRelationalCount = 3;

    @Override
    public SdClassContent converter(SdBean bean) {
        SdClassContent result = new SdClassContent();
        this.converterBean(bean, result);
        this.converterFields(bean, result);
        this.converterAdditionalField(bean, result);
        this.converterRelationals(bean, result);
        this.converterExtensions(bean, result);
        return result;
    }

    public void converterBean(SdBean bean, SdClassContent result) {
        result.setImports(bean.getImports());
        result.setAnnotations(bean.getAnnotations());
        result.setTableName(bean.getName());
        result.setAlias(bean.getAlias());
        result.setLowerName(bean.getName().toLowerCase());
        result.setUpperName(bean.getName().toUpperCase());
        result.setCamelName(SdUtil.toCamelCase(bean.getName()));
        result.setPascalName(SdUtil.toPascalCase(bean.getName()));
        result.setHyphenName(SdUtil.toHyphenCase(bean.getName()));
        result.setUnderScoreName(SdUtil.toUnderScoreCase(bean.getName()));
        result.setRemark(bean.getRemark());
    }

    public void converterFields(SdBean bean, SdClassContent result) {
        for (SdColumn col : bean.getColumns()) {
            Set<String> set;
            SdUtil.requireNonNull(col.getName(), "\u5c5e\u6027\u5217\u7684\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
            if (SdUtil.isNullOrEmpty(col.getFieldType())) {
                col.setFieldType(this.getTypeConverter().converter(col.getType()));
            }
            if (SdUtil.isNullOrEmpty(col.getFieldName())) {
                col.setFieldName(SdUtil.toCamelCase(col.getName()));
            }
            if (SdUtil.isNullOrEmpty(col.getFieldNameLower())) {
                col.setFieldNameLower(col.getName().toLowerCase());
            }
            if (SdUtil.isNullOrEmpty(col.getFieldNameUpper())) {
                col.setFieldNameUpper(col.getName().toUpperCase());
            }
            if (SdUtil.isNullOrEmpty(col.getFieldNamePascal())) {
                col.setFieldNamePascal(SdUtil.toPascalCase(col.getName()));
            }
            if (SdUtil.isNullOrEmpty(col.getFieldNameHyphen())) {
                col.setFieldNameHyphen(SdUtil.toHyphenCase(col.getName()));
            }
            if (SdUtil.isNullOrEmpty(col.getFieldNameUnderScore())) {
                col.setFieldNameUnderScore(SdUtil.toUnderScoreCase(col.getName()));
            }
            if (col.getFieldRemark() == null) {
                col.setFieldRemark(col.getRemark());
            }
            result.addField(col);
            boolean flag = true;
            if (col.isPrimary()) {
                result.addPrimaryField(col);
                flag = false;
            }
            if (col.isIndex()) {
                result.addIndexField(col);
                flag = false;
            }
            if (col.isForeignKey()) {
                result.addForeignField(col);
                flag = false;
            }
            if (flag) {
                result.addOtherField(col);
            }
            if (!col.isNullable()) {
                result.addCantNullField(col);
            }
            if ((set = col.getImports()) == null || set.isEmpty()) continue;
            for (String impt : set) {
                result.addImports(impt);
            }
        }
    }

    public void converterAdditionalField(SdBean bean, SdClassContent result) {
        if (bean.getAdditionalColumns() != null) {
            for (SdColumn col : bean.getAdditionalColumns()) {
                String name;
                if (col.getName() == null && col.getFieldName() == null) {
                    throw new NullPointerException("\u9644\u52a0\u5c5e\u6027\u4e2dname\u6216\u8005fieldName\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u540d\u5b57\u4e0d\u4e3a\u7a7a");
                }
                String string = name = col.getFieldName() == null ? col.getName() : col.getFieldName();
                if (SdUtil.isNullOrEmpty(col.getFieldType())) {
                    col.setFieldType(this.getTypeConverter().converter(col.getType()));
                }
                if (SdUtil.isNullOrEmpty(col.getFieldName())) {
                    col.setFieldName(SdUtil.toCamelCase(name));
                }
                if (SdUtil.isNullOrEmpty(col.getFieldNameLower())) {
                    col.setFieldNameLower(col.getName().toLowerCase());
                }
                if (SdUtil.isNullOrEmpty(col.getFieldNameUpper())) {
                    col.setFieldNameUpper(col.getName().toUpperCase());
                }
                if (SdUtil.isNullOrEmpty(col.getFieldNamePascal())) {
                    col.setFieldNamePascal(SdUtil.toPascalCase(name));
                }
                if (SdUtil.isNullOrEmpty(col.getFieldNameHyphen())) {
                    col.setFieldNameHyphen(SdUtil.toHyphenCase(name));
                }
                if (SdUtil.isNullOrEmpty(col.getFieldNameUnderScore())) {
                    col.setFieldNameUnderScore(SdUtil.toUnderScoreCase(name));
                }
                if (col.getFieldRemark() == null) {
                    col.setFieldRemark(col.getRemark());
                }
                result.addAdditionalField(col);
            }
        }
    }

    public void converterRelationals(SdBean bean, SdClassContent result) {
        if (bean.getRelationals() != null) {
            for (SdRelational rel : bean.getRelationals()) {
                if (rel.getImports() != null) {
                    for (String impt : rel.getImports()) {
                        result.addImports(impt);
                    }
                }
                SdRelationalContent relational = this.newNonClassContentRelationalContent(rel);
                if (rel.getBean() != null) {
                    SdClassContent classContent = new SdClassContent();
                    this.converterRelationals(rel.getBean(), classContent, 0);
                    relational.setClassContent(classContent);
                }
                result.addRelational(relational);
            }
        }
    }

    public void converterRelationals(SdBean bean, SdClassContent result, int count) {
        if (count >= this.defaltRelationalCount) {
            return;
        }
        this.converterBean(bean, result);
        this.converterFields(bean, result);
        this.converterAdditionalField(bean, result);
        if (bean.getRelationals() != null) {
            for (SdRelational rel : bean.getRelationals()) {
                if (rel.getImports() != null) {
                    for (String impt : rel.getImports()) {
                        result.addImports(impt);
                    }
                }
                SdRelationalContent relational = this.newNonClassContentRelationalContent(rel);
                if (rel.getBean() != null) {
                    SdClassContent classContent = new SdClassContent();
                    this.converterRelationals(rel.getBean(), classContent, ++count);
                    relational.setClassContent(classContent);
                }
                result.addRelational(relational);
            }
        }
        this.converterExtensions(bean, result);
    }

    public SdRelationalContent newNonClassContentRelationalContent(SdRelational rel) {
        SdRelationalContent content = new SdRelationalContent();
        content.setImports(rel.getImports());
        content.setAnnotations(rel.getAnnotations());
        content.setRelationalType(rel.getRelationalType());
        content.setFieldRemark(rel.getFieldRemark());
        content.setFieldType(rel.getFieldType());
        content.setFieldName(rel.getFieldName());
        content.setLowerName(rel.getFieldName().toLowerCase());
        content.setUpperName(rel.getFieldName().toUpperCase());
        content.setPascalName(SdUtil.toPascalCase(rel.getFieldName()));
        content.setCamelName(SdUtil.toCamelCase(rel.getFieldName()));
        content.setHyphenName(SdUtil.toHyphenCase(rel.getFieldName()));
        content.setUnderScoreName(SdUtil.toUnderScoreCase(rel.getFieldName()));
        content.setExtensions(rel.getExtensions());
        return content;
    }

    public void converterExtensions(SdBean bean, SdClassContent result) {
        result.setExtensions(bean.getExtensions());
    }

    public SdAbstractClassConverter setDefaltRelationalCount(int defaltRelationalCount) {
        this.defaltRelationalCount = defaltRelationalCount;
        return this;
    }
}

