/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mirrentools.sd.converter.SdTableToClassConverter;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdColumn;
import org.mirrentools.sd.models.db.query.SdTable;
import org.mirrentools.sd.models.db.query.SdTableAttribute;
import org.mirrentools.sd.models.db.query.SdTableColumnAttribute;
import org.mirrentools.sd.models.db.query.SdTableIndexKeyAttribute;
import org.mirrentools.sd.models.db.query.SdTablePortedKeysAttribute;
import org.mirrentools.sd.models.db.query.SdTablePrimaryKeyAttribute;

public abstract class SdAbstractTableToClassConverter
implements SdTableToClassConverter {
    public String getIndexType(short type) {
        return null;
    }

    @Override
    public SdClassContent converter(SdTable table) {
        return this.getClassConverter().converter(this.getSdBean(table));
    }

    public SdBean getSdBean(SdTable table) {
        SdBean result = new SdBean();
        this.converterInfo(table, result);
        this.converterColumns(table, result);
        this.converterExtension(table, result);
        return result;
    }

    public void converterInfo(SdTable table, SdBean result) {
        SdTableAttribute info = table.getInfo();
        result.setName(info.getTableName());
        result.setRemark(info.getRemarks());
    }

    public void converterColumns(SdTable table, SdBean result) {
        Iterator<SdTablePortedKeysAttribute> primaryKey;
        LinkedHashMap<String, SdColumn> colMaps = new LinkedHashMap<String, SdColumn>();
        for (SdTableColumnAttribute col : table.getColumns()) {
            SdColumn column = new SdColumn();
            column.setName(col.getColumnName());
            column.setType(col.getTypeName());
            column.setLength(col.getColumnSize() == 0 ? null : Integer.valueOf(col.getColumnSize()));
            column.setRemark(col.getRemarks());
            column.setNullable(col.isNullable() == 1);
            column.setDefaults(col.getColumnDef());
            column.setAutoIncrement("YES".equals(col.getAutoincrement()));
            column.setOrdinalPosition(col.getOrdinalPosition());
            colMaps.put(col.getColumnName(), column);
        }
        if (table.getPrimaryKey() != null && colMaps.get(((SdTablePrimaryKeyAttribute)((Object)(primaryKey = table.getPrimaryKey()))).getColumnName()) != null) {
            ((SdColumn)colMaps.get(((SdTablePrimaryKeyAttribute)((Object)primaryKey)).getColumnName())).setPrimary(true).setPrimaryName(((SdTablePrimaryKeyAttribute)((Object)primaryKey)).getPkName());
        }
        if (table.getIndexKeys() != null) {
            for (SdTableIndexKeyAttribute index : table.getIndexKeys()) {
                if (colMaps.get(index.getColumnName()) == null) continue;
                ((SdColumn)colMaps.get(index.getColumnName())).setIndexName(index.getIndexName()).setIndexType(this.getIndexType(index.getType()));
            }
        }
        if (table.getForeignKeys() != null) {
            for (SdTablePortedKeysAttribute foreginkey : table.getForeignKeys()) {
                if (colMaps.get(foreginkey.getFkcolumnName()) == null) continue;
                ((SdColumn)colMaps.get(foreginkey.getFkcolumnName())).setForeignConstraint(foreginkey.getFkName()).setForeignReferencesDB(foreginkey.getFktableCat()).setForeignReferencesTable(foreginkey.getFktableName()).setForeignReferencesColumn(foreginkey.getFkcolumnName());
            }
        }
        ArrayList<SdColumn> list = new ArrayList<SdColumn>(colMaps.values());
        Collections.sort(list);
        result.setColumns(list);
    }

    public void converterExtension(SdTable table, SdBean result) {
        result.setExtensions(table.getExtensions());
    }
}

