/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.mirrentools.sd.ScrewDriverCode;
import org.mirrentools.sd.ScrewDriverTemplateEngine;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.converter.SdClassConverter;
import org.mirrentools.sd.converter.SdTemplateContentConverter;
import org.mirrentools.sd.models.SdBean;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdRenderContent;
import org.mirrentools.sd.models.SdTemplate;
import org.mirrentools.sd.models.SdTemplateContent;
import org.mirrentools.sd.options.ScrewDriverOptions;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class ScrewDriverCodeImpl
implements ScrewDriverCode {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private SdDatabaseOptions databaseOptions;
    private String outputPath;
    private String codeFormat;
    private SdClassConverter beanConverter;
    private SdTemplateContentConverter templateConverter;
    private ScrewDriverTemplateEngine templateEngine;
    private Map<String, Object> extensions;

    public ScrewDriverCodeImpl(ScrewDriverOptions options) {
        SdUtil.requireNonNull(options, "The ScrewDriverOptions cannot be null ,you can new ScrewDriver(db name)Options");
        this.databaseOptions = options.getDatabaseOptions();
        this.outputPath = options.getOutputPath();
        this.beanConverter = options.getBeanConverter();
        this.templateConverter = options.getTemplateContentConverter();
        this.templateEngine = options.getTemplateEngine();
        this.extensions = options.getExtensions();
    }

    @Override
    public boolean execute(SdBean bean, Map<String, SdTemplate> templateMaps) {
        SdUtil.requireNonNull(bean, "The bean cannot ba null");
        return this.execute(this.beanConverter.converter(bean), templateMaps);
    }

    @Override
    public boolean execute(SdClassContent classContent, Map<String, SdTemplate> templateMaps) {
        SdUtil.requireNonNull(templateMaps, "SdTemplate cannot be null ,You need to create a SdTemplate first, because you need it to generate it.");
        String path = this.getOutputPath();
        String format = this.getCodeFormat();
        Map<String, SdTemplateContent> templates = this.templateConverter.converter(classContent, this.databaseOptions, templateMaps);
        SdRenderContent content = new SdRenderContent(classContent, this.databaseOptions, templates);
        for (Map.Entry<String, SdTemplate> temp : templateMaps.entrySet()) {
            this.LOG.info(String.format("Generating %s...", temp.getKey()));
            boolean render = this.templateEngine.render(path, format, content, temp.getValue());
            if (render) {
                this.LOG.info(String.format("Generated %s--> Successful!", temp.getKey()));
                continue;
            }
            this.LOG.warning(String.format("Generated %s--> Failed,render result false!", temp.getKey()));
        }
        return true;
    }

    @Override
    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public ScrewDriverCodeImpl setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @Override
    public String getCodeFormat() {
        return this.codeFormat == null ? "UTF-8" : this.codeFormat;
    }

    @Override
    public ScrewDriverCodeImpl setCodeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
        return this;
    }

    @Override
    public SdDatabaseOptions getDatabaseOptions() {
        return this.databaseOptions;
    }

    @Override
    public ScrewDriverCodeImpl setDatabaseOptions(SdDatabaseOptions dbOptions) {
        this.databaseOptions = dbOptions;
        return this;
    }

    @Override
    public SdClassConverter getBeanConverter() {
        return this.beanConverter;
    }

    @Override
    public ScrewDriverCodeImpl setBeanConverter(SdClassConverter beanConverter) {
        this.beanConverter = beanConverter;
        return this;
    }

    @Override
    public SdTemplateContentConverter getTemplateConverter() {
        return this.templateConverter;
    }

    @Override
    public ScrewDriverCodeImpl setTemplateConverter(SdTemplateContentConverter templateConverter) {
        this.templateConverter = templateConverter;
        return this;
    }

    @Override
    public ScrewDriverTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public ScrewDriverCodeImpl setTemplateEngine(ScrewDriverTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    @Override
    public ScrewDriverCode addExtension(String key, Object value) {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    @Override
    public Map<String, Object> getExtensions() {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        return this.extensions;
    }

    @Override
    public ScrewDriverCode setExtensions(Map<String, Object> extensions) {
        this.LOG.warning("This method expands the field as an alternate field, which can be inherited and rewritten if needed.");
        this.extensions = extensions;
        return this;
    }
}

