/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Logger;
import org.mirrentools.sd.ScrewDriverException;
import org.mirrentools.sd.ScrewDriverTemplateEngine;
import org.mirrentools.sd.common.SdTemplatePathUtil;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdRenderContent;
import org.mirrentools.sd.models.SdTemplate;
import org.mvel2.templates.TemplateRuntime;

public class ScrewDriverTemplateMvelImpl
extends ScrewDriverTemplateEngine {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    @Override
    public boolean render(String outputPath, String format, SdRenderContent content, SdTemplate template) {
        String projectPath;
        StringBuilder path = new StringBuilder();
        String string = projectPath = SdUtil.isNullOrEmpty(outputPath) ? SdUtil.getUserDir() : outputPath;
        if (!projectPath.endsWith("/") && !projectPath.endsWith("\\")) {
            path.append(projectPath + "/");
        } else {
            path.append(projectPath);
        }
        if (!template.getSourceFolder().endsWith("/") && !template.getSourceFolder().endsWith("\\")) {
            path.append(template.getSourceFolder() + "/");
        } else {
            path.append(template.getSourceFolder());
        }
        path.append(template.getPackageName().replace(".", "/"));
        String outputDirPath = path.toString();
        if (!outputDirPath.endsWith("/") && !outputDirPath.endsWith("\\")) {
            outputDirPath = outputDirPath + "/";
        }
        String outputFilePath = outputDirPath + template.getClassName() + template.getSuffix();
        if (!template.isOverride() && new File(outputFilePath).exists()) {
            this.LOG.info("\u8bbe\u7f6e\u4e86\u6587\u4ef6\u5b58\u5728\u4e0d\u8986\u76d6,\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728,\u5ffd\u7565\u672c\u6587\u4ef6\u7684\u521b\u5efa");
            return false;
        }
        Writer writer = null;
        try {
            boolean mkdirs;
            HashMap<String, SdRenderContent> dataModel = new HashMap<String, SdRenderContent>();
            dataModel.put("content", content);
            File outDir = new File(outputDirPath);
            if (!outDir.exists() && !(mkdirs = outDir.mkdirs())) {
                this.LOG.warning("\u6267\u884c\u521b\u5efa\u6587\u4ef6\u8f93\u51fa\u6587\u4ef6\u5939\u7ed3\u679c: " + mkdirs);
            }
            File file = SdTemplatePathUtil.getFile(template.getPath(), template.getFile());
            String templateStr = SdUtil.readFileToString(file);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), format);
            Object result = TemplateRuntime.eval((String)templateStr, dataModel);
            writer.write(result.toString());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new ScrewDriverException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.LOG.warning(e.getMessage());
                }
            }
        }
    }
}

