/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdRelationalContent;

public class SdColumn
implements Comparable<SdColumn> {
    private Set<String> imports;
    private Set<String> annotations;
    private SdRelationalContent relationalContent;
    private String fieldType;
    private String fieldName;
    private String fieldNameLower;
    private String fieldNameUpper;
    private String fieldNamePascal;
    private String fieldNameHyphen;
    private String fieldNameUnderScore;
    private String fieldRemark;
    private String name;
    private String type;
    private String remark;
    private Integer length;
    private Integer precision;
    private String defaults;
    private boolean primary;
    private String primaryName;
    private boolean foreignKey;
    private String foreignConstraint;
    private String foreignReferencesDB;
    private String foreignReferencesTable;
    private String foreignReferencesColumn;
    private boolean index;
    private boolean unique;
    private boolean concurrently;
    private String indexType;
    private String indexName;
    private String indexRemark;
    private boolean nullable = true;
    private boolean unsigned;
    private boolean autoIncrement;
    private boolean identity;
    private Integer identitySeed;
    private Integer identityIncrement;
    private String sequenceName;
    private String constraintType;
    private String constraintName;
    private String constraintExp;
    private String collate;
    private int ordinalPosition;
    private Map<String, Object> extensions;

    public Set<String> getImports() {
        return this.imports;
    }

    public SdColumn addImport(String imports) {
        if (this.getImports() == null) {
            this.imports = new LinkedHashSet<String>();
        }
        this.imports.add(imports);
        return this;
    }

    public SdColumn setImports(Set<String> imports) {
        this.imports = imports;
        return this;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public SdColumn addAnnotation(String annotation) {
        if (this.getAnnotations() == null) {
            this.setAnnotations(new LinkedHashSet<String>());
        }
        this.annotations.add(annotation);
        return this;
    }

    public SdColumn setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public SdRelationalContent getRelationalContent() {
        return this.relationalContent;
    }

    public SdColumn setRelationalContent(SdRelationalContent relationalContent) {
        this.relationalContent = relationalContent;
        return this;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public SdColumn setFieldType(String fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldNameLower() {
        return this.fieldNameLower;
    }

    public SdColumn setFieldNameLower(String fieldNameLower) {
        this.fieldNameLower = fieldNameLower;
        return this;
    }

    public String getFieldNameUpper() {
        return this.fieldNameUpper;
    }

    public SdColumn setFieldNameUpper(String fieldNameUpper) {
        this.fieldNameUpper = fieldNameUpper;
        return this;
    }

    public SdColumn setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public String getFieldNamePascal() {
        return this.fieldNamePascal;
    }

    public SdColumn setFieldNamePascal(String fieldNamePascal) {
        this.fieldNamePascal = fieldNamePascal;
        return this;
    }

    public String getFieldNameHyphen() {
        return this.fieldNameHyphen;
    }

    public SdColumn setFieldNameHyphen(String fieldNameHyphen) {
        this.fieldNameHyphen = fieldNameHyphen;
        return this;
    }

    public String getFieldNameUnderScore() {
        return this.fieldNameUnderScore;
    }

    public SdColumn setFieldNameUnderScore(String fieldNameUnderScore) {
        this.fieldNameUnderScore = fieldNameUnderScore;
        return this;
    }

    public String getFieldRemark() {
        return this.fieldRemark;
    }

    public SdColumn setFieldRemark(String fieldRemark) {
        this.fieldRemark = fieldRemark;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SdColumn setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SdColumn setType(String type) {
        this.type = type;
        return this;
    }

    public Integer getLength() {
        return this.length;
    }

    public SdColumn setLength(Integer length) {
        this.length = length;
        return this;
    }

    public SdColumn setLength(Integer length, Integer precision) {
        this.length = length;
        this.precision = precision;
        return this;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public SdColumn setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public SdColumn setDefaults(String defaults) {
        this.defaults = defaults;
        return this;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public SdColumn setPrimary(boolean primary) {
        this.primary = primary;
        if (primary) {
            this.nullable = false;
        }
        return this;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public String getForeignConstraint() {
        return this.foreignConstraint;
    }

    public SdColumn setForeignConstraint(String foreignConstraint) {
        this.foreignConstraint = foreignConstraint;
        this.foreignKey = true;
        return this;
    }

    public String getForeignReferencesDB() {
        return this.foreignReferencesDB;
    }

    public SdColumn setForeignReferencesDB(String foreignReferencesDB) {
        this.foreignReferencesDB = foreignReferencesDB;
        this.foreignKey = true;
        return this;
    }

    public String getForeignReferencesTable() {
        return this.foreignReferencesTable;
    }

    public SdColumn setForeignReferencesTable(String foreignReferencesTable) {
        this.foreignReferencesTable = foreignReferencesTable;
        this.foreignKey = true;
        return this;
    }

    public String getForeignReferencesColumn() {
        return this.foreignReferencesColumn;
    }

    public SdColumn setForeignReferencesColumn(String foreignReferencesColumn) {
        this.foreignReferencesColumn = foreignReferencesColumn;
        return this;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public SdColumn setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
        return this;
    }

    public boolean isIndex() {
        return this.index;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public SdColumn setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public boolean isConcurrently() {
        return this.concurrently;
    }

    public SdColumn setConcurrently(boolean concurrently) {
        this.concurrently = concurrently;
        return this;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public SdColumn setIndexType(String indexType) {
        this.indexType = indexType;
        this.index = true;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public SdColumn setIndexName(String indexName) {
        this.indexName = indexName;
        this.index = true;
        return this;
    }

    public String getIndexRemark() {
        return this.indexRemark;
    }

    public SdColumn setIndexRemark(String indexRemark) {
        this.indexRemark = indexRemark;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public SdColumn setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public SdColumn setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
        return this;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public SdColumn setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public SdColumn setIdentity(boolean identity) {
        this.identity = identity;
        return this;
    }

    public Integer getIdentitySeed() {
        return this.identitySeed;
    }

    public Integer getIdentityIncrement() {
        return this.identityIncrement;
    }

    public SdColumn setIdentitySeed(Integer identitySeed) {
        this.identity = true;
        this.identitySeed = identitySeed;
        return this;
    }

    public SdColumn setIdentityIncrement(Integer identityIncrement) {
        this.identity = true;
        this.identityIncrement = identityIncrement;
        return this;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public SdColumn setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
        return this;
    }

    public String getConstraintType() {
        return this.constraintType;
    }

    public SdColumn setConstraintType(String constraintType) {
        this.constraintType = constraintType;
        return this;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public SdColumn setConstraintName(String constraintName) {
        this.constraintName = constraintName;
        return this;
    }

    public String getConstraintExp() {
        return this.constraintExp;
    }

    public SdColumn setConstraintExp(String constraintExp) {
        this.constraintExp = constraintExp;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public SdColumn setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getCollate() {
        return this.collate;
    }

    public SdColumn setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public SdColumn setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdColumn addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdColumn setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SdColumn: \n");
        sb.append("  \u2523\u2501imports = " + this.imports + "\n");
        sb.append("  \u2523\u2501annotations = " + this.annotations + "\n");
        sb.append("  \u2523\u2501relationalContent = " + this.relationalContent + "\n");
        sb.append("  \u2523\u2501fieldType = " + this.fieldType + "\n");
        sb.append("  \u2523\u2501fieldName = " + this.fieldName + "\n");
        sb.append("  \u2523\u2501fieldNameLower = " + this.fieldNameLower + "\n");
        sb.append("  \u2523\u2501fieldNameUpper = " + this.fieldNameUpper + "\n");
        sb.append("  \u2523\u2501fieldNamePascal = " + this.fieldNamePascal + "\n");
        sb.append("  \u2523\u2501fieldNameHyphen = " + this.fieldNameHyphen + "\n");
        sb.append("  \u2523\u2501fieldNameUnderScore = " + this.fieldNameUnderScore + "\n");
        sb.append("  \u2523\u2501fieldRemark = " + this.fieldRemark + "\n");
        sb.append("  \u2523\u2501name = " + this.name + "\n");
        sb.append("  \u2523\u2501type = " + this.type + "\n");
        sb.append("  \u2523\u2501remark = " + this.remark + "\n");
        sb.append("  \u2523\u2501length = " + this.length + "\n");
        sb.append("  \u2523\u2501precision = " + this.precision + "\n");
        sb.append("  \u2523\u2501defaults = " + this.defaults + "\n");
        sb.append("  \u2523\u2501primary = " + this.primary + "\n");
        sb.append("  \u2523\u2501primaryName = " + this.primaryName + "\n");
        sb.append("  \u2523\u2501foreignKey = " + this.foreignKey + "\n");
        sb.append("  \u2523\u2501foreignConstraint = " + this.foreignConstraint + "\n");
        sb.append("  \u2523\u2501foreignReferencesDB = " + this.foreignReferencesDB + "\n");
        sb.append("  \u2523\u2501foreignReferencesTable = " + this.foreignReferencesTable + "\n");
        sb.append("  \u2523\u2501foreignReferencesColumn = " + this.foreignReferencesColumn + "\n");
        sb.append("  \u2523\u2501index = " + this.index + "\n");
        sb.append("  \u2523\u2501indexType = " + this.indexType + "\n");
        sb.append("  \u2523\u2501indexName = " + this.indexName + "\n");
        sb.append("  \u2523\u2501nullable = " + this.nullable + "\n");
        sb.append("  \u2523\u2501unsigned = " + this.unsigned + "\n");
        sb.append("  \u2523\u2501autoIncrement = " + this.autoIncrement + "\n");
        sb.append("  \u2523\u2501identity = " + this.identity + "\n");
        sb.append("  \u2523\u2501identitySeed = " + this.identitySeed + "\n");
        sb.append("  \u2523\u2501identityIncrement = " + this.identityIncrement + "\n");
        sb.append("  \u2523\u2501sequenceName = " + this.sequenceName + "\n");
        sb.append("  \u2523\u2501constraintType = " + this.constraintType + "\n");
        sb.append("  \u2523\u2501constraintName = " + this.constraintName + "\n");
        sb.append("  \u2523\u2501constraintExp = " + this.constraintExp + "\n");
        sb.append("  \u2523\u2501collate = " + this.collate + "\n");
        sb.append("  \u2523\u2501ordinalPosition = " + this.ordinalPosition + "\n");
        sb.append("  \u2517\u2501extensions = " + this.extensions + "\n");
        return sb.toString();
    }

    @Override
    public int compareTo(SdColumn obj) {
        return this.ordinalPosition > obj.getOrdinalPosition() ? 1 : (this.ordinalPosition == obj.getOrdinalPosition() ? 0 : -1);
    }
}

