/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdClassContent;
import org.mirrentools.sd.models.SdTemplateContent;
import org.mirrentools.sd.options.SdDatabaseOptions;

public class SdRenderContent {
    private SdClassContent content;
    private SdDatabaseOptions dbOptions;
    private Map<String, SdTemplateContent> items;
    private Map<String, Object> extensions;

    public SdRenderContent() {
    }

    public SdRenderContent(SdClassContent content, SdDatabaseOptions dbOptions, Map<String, SdTemplateContent> items) {
        this.content = content;
        this.dbOptions = dbOptions;
        this.items = items;
    }

    public SdClassContent getContent() {
        return this.content;
    }

    public SdRenderContent setContent(SdClassContent content) {
        this.content = content;
        return this;
    }

    public SdDatabaseOptions getDbOptions() {
        return this.dbOptions;
    }

    public SdRenderContent setDbOptions(SdDatabaseOptions dbOptions) {
        this.dbOptions = dbOptions;
        return this;
    }

    public Map<String, SdTemplateContent> getItems() {
        return this.items;
    }

    public SdRenderContent putItem(String key, SdTemplateContent item) {
        if (this.getItems() == null) {
            this.setItems(new LinkedHashMap<String, SdTemplateContent>());
        }
        this.getItems().put(key, item);
        return this;
    }

    public SdRenderContent setItems(Map<String, SdTemplateContent> items) {
        this.items = items;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdRenderContent addExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdRenderContent setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        return "SdRenderContent [content=" + this.content + ", dbOptions=" + this.dbOptions + ", items=" + this.items + "]";
    }
}

