/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mirrentools.sd.common.SdUtil;
import org.mirrentools.sd.models.SdTemplateAttribute;

public class SdTemplate {
    private String path;
    private String file;
    private boolean override = true;
    private String sourceFolder = "src/main/java/";
    private String packageName;
    private String className;
    private String suffix = ".java";
    private List<SdTemplateAttribute> attributes;
    private Map<String, Object> extensions;

    public String getPath() {
        return this.path;
    }

    public SdTemplate setPath(String path) {
        this.path = path;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public SdTemplate setFile(String file) {
        this.file = file;
        return this;
    }

    public boolean isOverride() {
        return this.override;
    }

    public SdTemplate setOverride(boolean override) {
        this.override = override;
        return this;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public SdTemplate setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public SdTemplate setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public SdTemplate setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public SdTemplate setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public SdTemplateAttribute getAttribute(int index) {
        if (SdUtil.isNullOrEmpty(this.getAttributes()) || index > this.getAttributes().size()) {
            return null;
        }
        return this.getAttributes().get(index);
    }

    public List<SdTemplateAttribute> getAttributes() {
        return this.attributes;
    }

    public SdTemplate addAttribute(SdTemplateAttribute attr) {
        if (SdUtil.isNullOrEmpty((Object)attr)) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<SdTemplateAttribute>();
        }
        this.attributes.add(attr);
        return this;
    }

    public SdTemplate setAttributes(List<SdTemplateAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Object getExtension(String key) {
        if (SdUtil.isNullOrEmpty(this.getExtensions())) {
            return null;
        }
        return this.getExtensions().get(key);
    }

    public SdTemplate putExtension(String key, Object value) {
        if (this.getExtensions() == null) {
            this.setExtensions(new LinkedHashMap<String, Object>());
        }
        this.getExtensions().put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public SdTemplate setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SdTemplate: \n");
        sb.append("\u2523\u2501path = " + this.path + "\n");
        sb.append("\u2523\u2501file = " + this.file + "\n");
        sb.append("\u2523\u2501override = " + this.override + "\n");
        sb.append("\u2523\u2501sourceFolder = " + this.sourceFolder + "\n");
        sb.append("\u2523\u2501packageName = " + this.packageName + "\n");
        sb.append("\u2523\u2501className = " + this.className + "\n");
        sb.append("\u2523\u2501suffix = " + this.suffix + "\n");
        sb.append("\u2517\u2501extensions = " + this.extensions + "\n");
        return sb.toString();
    }
}

