/*
 * Decompiled with CFR 0.152.
 */
package org.mirrentools.sd.models.db.update.impl.db2;

import java.util.ArrayList;
import java.util.List;
import org.mirrentools.sd.models.db.update.SdAbstractColumnContent;
import org.mirrentools.sd.models.db.update.SdAbstractForeignKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractIndexKeyContent;
import org.mirrentools.sd.models.db.update.SdAbstractTableContent;

public class SdTableContentByDB2
extends SdAbstractTableContent {
    @Override
    public List<String> createSQL() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String tbname = (this.getSchema() == null ? "" : this.getSchema() + ".") + this.getTableName();
        sb.append("CREATE TABLE  " + tbname + "(");
        for (int i = 0; i < this.getColums().size(); ++i) {
            sb.append(this.getColums().get(i).createSQL());
            if (i != this.getColums().size() - 1) {
                sb.append(",");
            }
            if (this.getColums().get(i).getRemark() == null) continue;
            result.add("comment on column " + tbname + "." + this.getColums().get(i).getName() + " is'" + this.getColums().get(i).getRemark() + "'");
        }
        sb.append(")");
        result.add(0, sb.toString());
        if (this.getRemark() != null) {
            result.add("comment on table " + tbname + " is '" + this.getRemark() + "'");
        }
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            for (SdAbstractIndexKeyContent index : this.getIndexKeys()) {
                result.add(index.createSQL());
            }
        }
        if (this.getForeignKeys() != null && !this.getForeignKeys().isEmpty()) {
            for (SdAbstractForeignKeyContent foreignkey : this.getForeignKeys()) {
                result.add(foreignkey.createSQL());
            }
        }
        return result;
    }

    @Override
    public List<String> updateSQL() {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE `" + this.getTableName() + "`");
        for (i = 0; i < this.getColums().size(); ++i) {
            sb.append(this.getColums().get(i).updateSQL());
            if (i == this.getColums().size() - 1) continue;
            sb.append(",");
        }
        if (this.getPrimaryKey() != null && this.getPrimaryKey().getColumns() != null && !this.getPrimaryKey().getColumns().isEmpty()) {
            sb.append(",");
            sb.append(this.getPrimaryKey().updateSQL());
        }
        if (this.getIndexKeys() != null && !this.getIndexKeys().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getIndexKeys().size(); ++i) {
                sb.append(this.getIndexKeys().get(i).updateSQL());
                if (i == this.getIndexKeys().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getForeignKeys() != null && !this.getForeignKeys().isEmpty()) {
            sb.append(",");
            for (i = 0; i < this.getForeignKeys().size(); ++i) {
                sb.append(this.getForeignKeys().get(i).updateSQL());
                if (i == this.getForeignKeys().size() - 1) continue;
                sb.append(",");
            }
        }
        if (this.getRemark() != null) {
            sb.append(", COMMENT='" + this.getRemark() + "'");
        }
        sb.append(";");
        return result;
    }

    @Override
    public String deleteSQL() {
        return " DROP TABLE `" + this.getTableName() + "`;";
    }

    public String createTableComment() {
        return String.format(" COMMENT ON TABLE %s.%s IS '%s';\n", this.getSchema(), this.getTableName(), this.getRemark());
    }

    public String createColumnComment(SdAbstractColumnContent column) {
        return String.format(" COMMENT ON COLUMN %s.%s.%s IS '%s';\n", this.getSchema(), this.getTableName(), column.getName(), column.getRemark());
    }

    @Override
    public String toString() {
        return "SdTableContentByDB2 []";
    }
}

