/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.discovery.view;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="webfingerView")
public class WebfingerView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(WebfingerView.class);
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new /* Unavailable Anonymous Inner Class!! */}).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/jrd+json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        try {
            String resource = (String)model.get("resource");
            String issuer = (String)model.get("issuer");
            JsonObject obj = new JsonObject();
            obj.addProperty("subject", resource);
            JsonArray links = new JsonArray();
            JsonObject link = new JsonObject();
            link.addProperty("rel", "http://openid.net/specs/connect/1.0/issuer");
            link.addProperty("href", issuer);
            links.add((JsonElement)link);
            obj.add("links", (JsonElement)links);
            PrintWriter out = response.getWriter();
            this.gson.toJson((JsonElement)obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in JsonEntityView.java: ", (Throwable)e);
        }
    }
}

