/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class JpaOAuth2ClientRepository
implements OAuth2ClientRepository {
    @PersistenceContext
    private EntityManager manager;

    public JpaOAuth2ClientRepository() {
    }

    public JpaOAuth2ClientRepository(EntityManager manager) {
        this.manager = manager;
    }

    public ClientDetailsEntity getById(Long id) {
        return (ClientDetailsEntity)this.manager.find(ClientDetailsEntity.class, (Object)id);
    }

    public ClientDetailsEntity getClientByClientId(String clientId) {
        TypedQuery query = this.manager.createNamedQuery("ClientDetailsEntity.getByClientId", ClientDetailsEntity.class);
        query.setParameter("clientId", (Object)clientId);
        return (ClientDetailsEntity)JpaUtil.getSingleResult((List)query.getResultList());
    }

    public ClientDetailsEntity saveClient(ClientDetailsEntity client) {
        return (ClientDetailsEntity)JpaUtil.saveOrUpdate((Object)client.getClientId(), (EntityManager)this.manager, (Object)client);
    }

    public void deleteClient(ClientDetailsEntity client) {
        ClientDetailsEntity found = this.getById(client.getId());
        if (found == null) {
            throw new IllegalArgumentException("Client not found: " + client);
        }
        this.manager.remove((Object)found);
    }

    public ClientDetailsEntity updateClient(Long id, ClientDetailsEntity client) {
        client.setId(id);
        return (ClientDetailsEntity)JpaUtil.saveOrUpdate((Object)id, (EntityManager)this.manager, (Object)client);
    }

    public Collection<ClientDetailsEntity> getAllClients() {
        TypedQuery query = this.manager.createNamedQuery("ClientDetailsEntity.findAll", ClientDetailsEntity.class);
        return query.getResultList();
    }
}

