/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import org.mitre.oauth2.model.AuthorizationCodeEntity;
import org.mitre.oauth2.repository.AuthorizationCodeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationRequestHolder;
import org.springframework.stereotype.Service;

@Service
public class DefaultOAuth2AuthorizationCodeService
implements AuthorizationCodeServices {
    @Autowired
    private AuthorizationCodeRepository repository;
    private RandomValueStringGenerator generator = new RandomValueStringGenerator();

    public String createAuthorizationCode(AuthorizationRequestHolder authentication) {
        String code = this.generator.generate();
        AuthorizationCodeEntity entity = new AuthorizationCodeEntity(code, authentication);
        this.repository.save(entity);
        return code;
    }

    public AuthorizationRequestHolder consumeAuthorizationCode(String code) throws InvalidGrantException {
        AuthorizationRequestHolder auth = this.repository.consume(code);
        return auth;
    }

    public AuthorizationCodeRepository getRepository() {
        return this.repository;
    }

    public void setRepository(AuthorizationCodeRepository repository) {
        this.repository = repository;
    }
}

