/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Service;

@Service
public class DefaultOAuth2ClientDetailsEntityService
implements ClientDetailsEntityService {
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private WhitelistedSiteService whitelistedSiteService;
    @Autowired
    private BlacklistedSiteService blacklistedSiteService;

    public DefaultOAuth2ClientDetailsEntityService() {
    }

    public DefaultOAuth2ClientDetailsEntityService(OAuth2ClientRepository clientRepository, OAuth2TokenRepository tokenRepository) {
        this.clientRepository = clientRepository;
        this.tokenRepository = tokenRepository;
    }

    public ClientDetailsEntity saveNewClient(ClientDetailsEntity client) {
        if (client.getId() != null) {
            throw new IllegalArgumentException("Tried to save a new client with an existing ID: " + client.getId());
        }
        if (client.getRegisteredRedirectUri() != null) {
            for (String uri : client.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.generateClientId(client);
        }
        if (client.isAllowRefresh()) {
            client.getScope().add("offline_access");
        } else {
            client.getScope().remove("offline_access");
        }
        client.setCreatedAt(new Date());
        return this.clientRepository.saveClient(client);
    }

    public ClientDetailsEntity getClientById(Long id) {
        ClientDetailsEntity client = this.clientRepository.getById(id);
        return client;
    }

    public ClientDetailsEntity loadClientByClientId(String clientId) throws OAuth2Exception, InvalidClientException, IllegalArgumentException {
        if (!Strings.isNullOrEmpty((String)clientId)) {
            ClientDetailsEntity client = this.clientRepository.getClientByClientId(clientId);
            if (client == null) {
                throw new InvalidClientException("Client with id " + clientId + " was not found");
            }
            return client;
        }
        throw new IllegalArgumentException("Client id must not be empty!");
    }

    public void deleteClient(ClientDetailsEntity client) throws InvalidClientException {
        if (this.clientRepository.getById(client.getId()) == null) {
            throw new InvalidClientException("Client with id " + client.getClientId() + " was not found");
        }
        this.tokenRepository.clearTokensForClient(client);
        this.approvedSiteService.clearApprovedSitesForClient((ClientDetails)client);
        WhitelistedSite whitelistedSite = this.whitelistedSiteService.getByClientId(client.getClientId());
        if (whitelistedSite != null) {
            this.whitelistedSiteService.remove(whitelistedSite);
        }
        this.clientRepository.deleteClient(client);
    }

    public ClientDetailsEntity updateClient(ClientDetailsEntity oldClient, ClientDetailsEntity newClient) throws IllegalArgumentException {
        if (oldClient != null && newClient != null) {
            for (String uri : newClient.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
            if (newClient.isAllowRefresh()) {
                newClient.getScope().add("offline_access");
            } else {
                newClient.getScope().remove("offline_access");
            }
            return this.clientRepository.updateClient(oldClient.getId(), newClient);
        }
        throw new IllegalArgumentException("Neither old client or new client can be null!");
    }

    public Collection<ClientDetailsEntity> getAllClients() {
        return this.clientRepository.getAllClients();
    }

    public ClientDetailsEntity generateClientId(ClientDetailsEntity client) {
        client.setClientId(UUID.randomUUID().toString());
        return client;
    }

    public ClientDetailsEntity generateClientSecret(ClientDetailsEntity client) {
        client.setClientSecret(Base64.encodeBase64URLSafeString((byte[])new BigInteger(512, new SecureRandom()).toByteArray()).replace("=", ""));
        return client;
    }
}

