/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.repository.SystemScopeRepository;
import org.mitre.oauth2.service.SystemScopeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defaultSystemScopeService")
public class DefaultSystemScopeService
implements SystemScopeService {
    @Autowired
    private SystemScopeRepository repository;
    private Predicate<SystemScope> isDefault = new /* Unavailable Anonymous Inner Class!! */;
    private Predicate<SystemScope> isDynReg = new /* Unavailable Anonymous Inner Class!! */;
    private Function<String, SystemScope> stringToSystemScope = new /* Unavailable Anonymous Inner Class!! */;
    private Function<SystemScope, String> systemScopeToString = new /* Unavailable Anonymous Inner Class!! */;

    public Set<SystemScope> getAll() {
        return this.repository.getAll();
    }

    public Set<SystemScope> getDefaults() {
        return Sets.filter((Set)this.getAll(), (Predicate)this.isDefault);
    }

    public Set<SystemScope> getDynReg() {
        return Sets.filter((Set)this.getAll(), (Predicate)this.isDynReg);
    }

    public SystemScope getById(Long id) {
        return this.repository.getById(id);
    }

    public SystemScope getByValue(String value) {
        return this.repository.getByValue(value);
    }

    public void remove(SystemScope scope) {
        this.repository.remove(scope);
    }

    public SystemScope save(SystemScope scope) {
        return this.repository.save(scope);
    }

    public Set<SystemScope> fromStrings(Set<String> scope) {
        if (scope == null) {
            return null;
        }
        return new LinkedHashSet<SystemScope>(Collections2.filter((Collection)Collections2.transform(scope, (Function)this.stringToSystemScope), (Predicate)Predicates.notNull()));
    }

    public Set<String> toStrings(Set<SystemScope> scope) {
        if (scope == null) {
            return null;
        }
        return new LinkedHashSet<String>(Collections2.filter((Collection)Collections2.transform(scope, (Function)this.systemScopeToString), (Predicate)Predicates.notNull()));
    }
}

