/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component(value="chainedTokenGranter")
public class ChainedTokenGranter
extends AbstractTokenGranter {
    private static final String grantType = "urn:ietf:params:oauth:grant_type:redelegate";
    private OAuth2TokenEntityService tokenServices;

    @Autowired
    public ChainedTokenGranter(OAuth2TokenEntityService tokenServices, ClientDetailsEntityService clientDetailsService) {
        super((AuthorizationServerTokenServices)tokenServices, (ClientDetailsService)clientDetailsService, grantType);
        this.tokenServices = tokenServices;
    }

    protected OAuth2Authentication getOAuth2Authentication(AuthorizationRequest authorizationRequest) throws AuthenticationException, InvalidTokenException {
        ClientDetailsEntity client;
        String incomingTokenValue = (String)authorizationRequest.getAuthorizationParameters().get("token");
        OAuth2AccessTokenEntity incomingToken = this.tokenServices.readAccessToken(incomingTokenValue);
        Set approvedScopes = incomingToken.getScope();
        HashSet requestedScopes = authorizationRequest.getScope();
        if (requestedScopes == null) {
            requestedScopes = new HashSet();
        }
        if ((client = incomingToken.getClient()).getScope().equals(requestedScopes)) {
            requestedScopes = new HashSet();
        }
        if (approvedScopes.containsAll(requestedScopes)) {
            DefaultAuthorizationRequest outgoingAuthRequest = new DefaultAuthorizationRequest(authorizationRequest);
            outgoingAuthRequest.setApproved(true);
            if (requestedScopes.isEmpty()) {
                outgoingAuthRequest.setScope(approvedScopes);
            } else {
                outgoingAuthRequest.setScope((Set)Sets.intersection(requestedScopes, (Set)approvedScopes));
            }
            OAuth2Authentication authentication = new OAuth2Authentication((AuthorizationRequest)outgoingAuthRequest, incomingToken.getAuthenticationHolder().getAuthentication().getUserAuthentication());
            return authentication;
        }
        throw new InvalidScopeException("Invalid scope requested in chained request", approvedScopes);
    }
}

