/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component(value="jwtAssertionTokenGranter")
public class JwtAssertionTokenGranter
extends AbstractTokenGranter {
    private static final String grantType = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private OAuth2TokenEntityService tokenServices;
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private ConfigurationPropertiesBean config;

    @Autowired
    public JwtAssertionTokenGranter(OAuth2TokenEntityService tokenServices, ClientDetailsEntityService clientDetailsService) {
        super((AuthorizationServerTokenServices)tokenServices, (ClientDetailsService)clientDetailsService, grantType);
        this.tokenServices = tokenServices;
    }

    protected OAuth2AccessToken getAccessToken(AuthorizationRequest authorizationRequest) throws AuthenticationException, InvalidTokenException {
        String incomingTokenValue = (String)authorizationRequest.getAuthorizationParameters().get("assertion");
        OAuth2AccessTokenEntity incomingToken = this.tokenServices.readAccessToken(incomingTokenValue);
        ClientDetailsEntity client = incomingToken.getClient();
        if (incomingToken.getScope().contains("id-token")) {
            if (!client.getClientId().equals(authorizationRequest.getClientId())) {
                throw new InvalidClientException("Not the right client for this token");
            }
            try {
                JWT idToken = JWTParser.parse((String)incomingTokenValue);
                OAuth2AccessTokenEntity accessToken = this.tokenServices.getAccessTokenForIdToken(incomingToken);
                if (accessToken != null) {
                    OAuth2AccessTokenEntity newIdTokenEntity = new OAuth2AccessTokenEntity();
                    JWTClaimsSet claims = new JWTClaimsSet(idToken.getJWTClaimsSet());
                    if (client.getIdTokenValiditySeconds() != null) {
                        Date expiration = new Date(System.currentTimeMillis() + (long)client.getIdTokenValiditySeconds().intValue() * 1000L);
                        claims.setExpirationTime(expiration);
                        newIdTokenEntity.setExpiration(expiration);
                    }
                    claims.setIssueTime(new Date());
                    SignedJWT newIdToken = new SignedJWT((JWSHeader)idToken.getHeader(), (ReadOnlyJWTClaimsSet)claims);
                    this.jwtService.signJwt(newIdToken);
                    newIdTokenEntity.setJwt((JWT)newIdToken);
                    newIdTokenEntity.setAuthenticationHolder(incomingToken.getAuthenticationHolder());
                    newIdTokenEntity.setScope(incomingToken.getScope());
                    newIdTokenEntity.setClient(incomingToken.getClient());
                    newIdTokenEntity = this.tokenServices.saveAccessToken(newIdTokenEntity);
                    accessToken.setIdToken(newIdTokenEntity);
                    accessToken = this.tokenServices.saveAccessToken(accessToken);
                    this.tokenServices.revokeAccessToken(incomingToken);
                    return newIdTokenEntity;
                }
            }
            catch (ParseException e) {
                this.logger.warn((Object)"Couldn't parse id token", (Throwable)e);
            }
        }
        return null;
    }
}

