/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IntrospectionEndpoint {
    @Autowired
    private OAuth2TokenEntityService tokenServices;
    @Autowired
    private ClientDetailsEntityService clientService;
    private static Logger logger = LoggerFactory.getLogger(IntrospectionEndpoint.class);

    public IntrospectionEndpoint() {
    }

    public IntrospectionEndpoint(OAuth2TokenEntityService tokenServices) {
        this.tokenServices = tokenServices;
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT')")
    @RequestMapping(value={"/introspect"})
    public String verify(@RequestParam(value="token") String tokenValue, Principal p, Model model) {
        if (Strings.isNullOrEmpty((String)tokenValue)) {
            logger.error("Verify failed; token value is null");
            ImmutableMap entity = ImmutableMap.of((Object)"valid", (Object)Boolean.FALSE);
            model.addAttribute("entity", (Object)entity);
            return "jsonEntityView";
        }
        OAuth2AccessTokenEntity token = null;
        try {
            token = this.tokenServices.readAccessToken(tokenValue);
        }
        catch (InvalidTokenException e) {
            logger.error("Verify failed; AuthenticationException: " + e.getStackTrace().toString());
            ImmutableMap entity = ImmutableMap.of((Object)"valid", (Object)Boolean.FALSE);
            model.addAttribute("entity", (Object)entity);
            return "jsonEntityView";
        }
        ClientDetailsEntity tokenClient = token.getClient();
        String clientId = p.getName();
        ClientDetailsEntity authClient = this.clientService.loadClientByClientId(clientId);
        if (tokenClient != null && authClient != null) {
            if (authClient.isAllowIntrospection()) {
                if (authClient.equals(tokenClient) || authClient.getScope().containsAll(token.getScope())) {
                    model.addAttribute("entity", (Object)token);
                    return "tokenIntrospection";
                }
                logger.error("Verify failed; client tried to introspect a token of an incorrect scope");
                model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                return "httpCodeView";
            }
            logger.error("Verify failed; client " + clientId + " is not allowed to call introspection endpoint");
            model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        logger.error("Verify failed; client " + clientId + " not found.");
        model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
        return "httpCodeView";
    }
}

