/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect;

import com.google.common.base.Strings;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetSigningAndValidationServiceCacheService;
import org.mitre.oauth2.exception.NonceReuseException;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.Nonce;
import org.mitre.openid.connect.service.NonceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.AuthorizationRequestManager;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.stereotype.Component;

@Component(value="authorizationRequestManager")
public class ConnectAuthorizationRequestManager
implements AuthorizationRequestManager {
    private static Logger logger = LoggerFactory.getLogger(ConnectAuthorizationRequestManager.class);
    @Autowired
    private NonceService nonceService;
    @Autowired
    private ClientDetailsEntityService clientDetailsService;
    @Autowired
    private JWKSetSigningAndValidationServiceCacheService validators;

    public ConnectAuthorizationRequestManager(ClientDetailsEntityService clientDetailsService, NonceService nonceService) {
        this.clientDetailsService = clientDetailsService;
        this.nonceService = nonceService;
    }

    public ConnectAuthorizationRequestManager() {
    }

    public AuthorizationRequest createAuthorizationRequest(Map<String, String> inputParams) {
        Set scopes;
        Map parameters = this.processRequestObject(inputParams);
        String clientId = (String)parameters.get("client_id");
        if (clientId == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(clientId);
        String requestNonce = (String)parameters.get("nonce");
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (requestNonce != null && principal != null && principal instanceof User) {
            if (!this.nonceService.alreadyUsed(clientId, requestNonce)) {
                Nonce nonce = this.nonceService.create(clientId, requestNonce);
                this.nonceService.save(nonce);
            } else {
                throw new NonceReuseException(client.getClientId(), requestNonce);
            }
        }
        if ((scopes = OAuth2Utils.parseParameterList((String)((String)parameters.get("scope")))) == null || scopes.isEmpty()) {
            Set clientScopes;
            scopes = clientScopes = client.getScope();
        }
        DefaultAuthorizationRequest request = new DefaultAuthorizationRequest(parameters, Collections.emptyMap(), clientId, (Collection)scopes);
        request.addClientDetails((ClientDetails)client);
        return request;
    }

    private Map<String, String> processRequestObject(Map<String, String> inputParams) {
        String jwtString = inputParams.get("request");
        if (Strings.isNullOrEmpty((String)jwtString)) {
            return inputParams;
        }
        HashMap<String, String> parameters = new HashMap<String, String>(inputParams);
        try {
            String scope;
            String prompt;
            String display;
            String nonce;
            String state;
            ClientDetailsEntity client;
            SignedJWT jwsObject = SignedJWT.parse((String)jwtString);
            JSONObject claims = jwsObject.getPayload().toJSONObject();
            String clientId = JSONObjectUtils.getString((JSONObject)claims, (String)"client_id");
            if (clientId != null) {
                parameters.put("client_id", clientId);
            }
            if ((client = this.clientDetailsService.loadClientByClientId(clientId)).getJwksUri() == null) {
                throw new InvalidClientException("Client must have a JWKS URI registered to use request objects.");
            }
            JwtSigningAndValidationService validator = this.validators.get(client.getJwksUri());
            if (validator == null) {
                throw new InvalidClientException("Unable to create signature validator for client's JWKS URI: " + client.getJwksUri());
            }
            if (!validator.validateSignature(jwsObject)) {
                throw new AuthenticationServiceException("Signature did not validate for presented JWT request object.");
            }
            String responseTypes = JSONObjectUtils.getString((JSONObject)claims, (String)"response_type");
            if (responseTypes != null) {
                parameters.put("response_type", responseTypes);
            }
            if (claims.get((Object)"redirect_uri") != null && !inputParams.containsKey("redirect_uri")) {
                parameters.put("redirect_uri", JSONObjectUtils.getString((JSONObject)claims, (String)"redirect_uri"));
            }
            if ((state = JSONObjectUtils.getString((JSONObject)claims, (String)"state")) != null && !inputParams.containsKey("state")) {
                parameters.put("state", state);
            }
            if ((nonce = JSONObjectUtils.getString((JSONObject)claims, (String)"nonce")) != null && !inputParams.containsKey("nonce")) {
                parameters.put("nonce", nonce);
            }
            if ((display = JSONObjectUtils.getString((JSONObject)claims, (String)"display")) != null && !inputParams.containsKey("display")) {
                parameters.put("display", display);
            }
            if ((prompt = JSONObjectUtils.getString((JSONObject)claims, (String)"prompt")) != null && !inputParams.containsKey("prompt")) {
                parameters.put("prompt", prompt);
            }
            if ((scope = JSONObjectUtils.getString((JSONObject)claims, (String)"scope")) != null && !inputParams.containsKey("scope")) {
                parameters.put("scope", scope);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parameters;
    }

    public void validateParameters(Map<String, String> parameters, ClientDetails clientDetails) {
        if (parameters.containsKey("scope") && clientDetails.isScoped()) {
            Set validScope = clientDetails.getScope();
            for (String scope : OAuth2Utils.parseParameterList((String)parameters.get("scope"))) {
                if (validScope.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, validScope);
            }
        }
    }
}

