/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.filter;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="promptFilter")
public class PromptFilter
extends GenericFilterBean {
    private Logger logger = LoggerFactory.getLogger(PromptFilter.class);

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (Strings.isNullOrEmpty((String)request.getParameter("prompt"))) {
            chain.doFilter(req, res);
            return;
        }
        if (!request.getParameter("prompt").equals("none")) {
            chain.doFilter(req, res);
            return;
        }
        this.logger.info("Client requested no prompt");
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            chain.doFilter(req, res);
            return;
        }
        this.logger.info("User not logged in, no prompt requested, returning 403 from filter");
        response.sendError(403, "Access Denied");
    }
}

