/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.mitre.openid.connect.model.Event;
import org.mitre.openid.connect.repository.EventRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaEventRepository
implements EventRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public Event getById(Long id) {
        return (Event)this.manager.find(Event.class, (Object)id);
    }

    @Transactional
    public Collection<Event> getEventsDuringPeriod(Date start, Date end, int startChunk, int chunkSize) {
        Query query = this.manager.createQuery("SELECT e FROM Event e WHERE e.timestamp BETWEEN :start AND :end");
        query = query.setParameter("start", start, TemporalType.DATE);
        query = query.setParameter("end", end, TemporalType.DATE);
        query = query.setFirstResult(startChunk);
        query = query.setMaxResults(chunkSize);
        return query.getResultList();
    }

    @Transactional
    public void remove(Event event) {
        Event found = (Event)this.manager.find(Event.class, (Object)event.getId());
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.manager.remove((Object)event);
    }

    @Transactional
    public void removeById(Long id) {
        Event found = this.getById(id);
        this.manager.remove((Object)found);
    }

    @Transactional
    public Event save(Event event) {
        return (Event)JpaUtil.saveOrUpdate((Object)event.getId(), (EntityManager)this.manager, (Object)event);
    }
}

