/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.openid.connect.model.Nonce;
import org.mitre.openid.connect.repository.NonceRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaNonceRepository
implements NonceRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public Nonce getById(Long id) {
        return (Nonce)this.manager.find(Nonce.class, (Object)id);
    }

    @Transactional
    public void remove(Nonce nonce) {
        Nonce found = (Nonce)this.manager.find(Nonce.class, (Object)nonce.getId());
        if (found == null) {
            throw new IllegalArgumentException("Nonce reporitory remove: Nonce with id " + nonce.getId() + " could not be found.");
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public Nonce save(Nonce nonce) {
        return (Nonce)JpaUtil.saveOrUpdate((Object)nonce.getId(), (EntityManager)this.manager, (Object)nonce);
    }

    @Transactional
    public Collection<Nonce> getAll() {
        TypedQuery query = this.manager.createNamedQuery("Nonce.getAll", Nonce.class);
        return query.getResultList();
    }

    @Transactional
    public Collection<Nonce> getExpired() {
        TypedQuery query = this.manager.createNamedQuery("Nonce.getExpired", Nonce.class);
        return query.getResultList();
    }

    @Transactional
    public Collection<Nonce> getByClientId(String clientId) {
        TypedQuery query = this.manager.createNamedQuery("Nonce.getByClientId", Nonce.class);
        query.setParameter("clientId", (Object)clientId);
        return query.getResultList();
    }
}

