/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DefaultApprovedSiteService
implements ApprovedSiteService {
    @Autowired
    private ApprovedSiteRepository approvedSiteRepository;

    public DefaultApprovedSiteService() {
    }

    public DefaultApprovedSiteService(ApprovedSiteRepository approvedSiteRepository) {
        this.approvedSiteRepository = approvedSiteRepository;
    }

    public Collection<ApprovedSite> getAll() {
        return this.approvedSiteRepository.getAll();
    }

    @Transactional
    public ApprovedSite save(ApprovedSite approvedSite) {
        return this.approvedSiteRepository.save(approvedSite);
    }

    public ApprovedSite getById(Long id) {
        return this.approvedSiteRepository.getById(id);
    }

    @Transactional
    public void remove(ApprovedSite approvedSite) {
        this.approvedSiteRepository.remove(approvedSite);
    }

    @Transactional
    public ApprovedSite createApprovedSite(String clientId, String userId, Date timeoutDate, Set<String> allowedScopes, WhitelistedSite whitelistedSite) {
        ApprovedSite as = this.approvedSiteRepository.save(new ApprovedSite());
        Date now = new Date();
        as.setCreationDate(now);
        as.setAccessDate(now);
        as.setClientId(clientId);
        as.setUserId(userId);
        as.setTimeoutDate(timeoutDate);
        as.setAllowedScopes(allowedScopes);
        as.setWhitelistedSite(whitelistedSite);
        return this.save(as);
    }

    public Collection<ApprovedSite> getByClientIdAndUserId(String clientId, String userId) {
        return this.approvedSiteRepository.getByClientIdAndUserId(clientId, userId);
    }

    public Collection<ApprovedSite> getByUserId(String userId) {
        return this.approvedSiteRepository.getByUserId(userId);
    }

    public Collection<ApprovedSite> getByClientId(String clientId) {
        return this.approvedSiteRepository.getByClientId(clientId);
    }

    public void clearApprovedSitesForClient(ClientDetails client) {
        Collection approvedSites = this.approvedSiteRepository.getByClientId(client.getClientId());
        if (approvedSites != null) {
            for (ApprovedSite approvedSite : approvedSites) {
                this.approvedSiteRepository.remove(approvedSite);
            }
        }
    }
}

