/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import java.util.Collection;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.mitre.openid.connect.model.Nonce;
import org.mitre.openid.connect.repository.NonceRepository;
import org.mitre.openid.connect.service.NonceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="defaultNonceService")
public class DefaultNonceService
implements NonceService,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(NonceService.class);
    @Autowired
    private NonceRepository repository;
    @Autowired
    private Period nonceStorageDuration;

    public void afterPropertiesSet() throws Exception {
        if (this.nonceStorageDuration == null) {
            logger.error("Nonce storage duration must be set!");
        }
    }

    public Nonce create(String clientId, String value) {
        Nonce nonce = new Nonce();
        nonce.setClientId(clientId);
        nonce.setValue(value);
        DateTime now = new DateTime((Object)new Date());
        nonce.setUseDate(now.toDate());
        DateTime expDate = now.plus((ReadablePeriod)this.nonceStorageDuration);
        Date expirationJdkDate = expDate.toDate();
        nonce.setExpireDate(expirationJdkDate);
        return nonce;
    }

    public boolean alreadyUsed(String clientId, String value) {
        Collection clientNonces = this.getByClientId(clientId);
        for (Nonce nonce : clientNonces) {
            String nonceVal = nonce.getValue();
            if (!nonceVal.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Nonce getById(Long id) {
        return this.repository.getById(id);
    }

    public void remove(Nonce nonce) {
        this.repository.remove(nonce);
    }

    public Nonce save(Nonce nonce) {
        return this.repository.save(nonce);
    }

    public Collection<Nonce> getAll() {
        return this.repository.getAll();
    }

    public Collection<Nonce> getExpired() {
        return this.repository.getExpired();
    }

    public Collection<Nonce> getByClientId(String clientId) {
        return this.repository.getByClientId(clientId);
    }

    @Scheduled(fixedRate=300000L)
    public void clearExpiredNonces() {
        logger.info("Clearing expired nonces");
        Collection expired = this.repository.getExpired();
        logger.info("Found " + expired.size() + " expired nonces");
        for (Nonce nonce : expired) {
            this.remove(nonce);
        }
    }

    public NonceRepository getRepository() {
        return this.repository;
    }

    public void setRepository(NonceRepository repository) {
        this.repository = repository;
    }

    public Period getNonceStorageDuration() {
        return this.nonceStorageDuration;
    }

    public void setNonceStorageDuration(Period nonceStorageDuration) {
        this.nonceStorageDuration = nonceStorageDuration;
    }
}

