/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.token;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpSession;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ConnectTokenEnhancer
implements TokenEnhancer {
    Logger logger = LoggerFactory.getLogger(ConnectTokenEnhancer.class);
    @Autowired
    private ConfigurationPropertiesBean configBean;
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private ClientDetailsEntityService clientService;

    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        OAuth2AccessTokenEntity token = (OAuth2AccessTokenEntity)accessToken;
        String clientId = authentication.getAuthorizationRequest().getClientId();
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setAudience((List)Lists.newArrayList((Object[])new String[]{clientId}));
        claims.setIssuer(this.configBean.getIssuer());
        claims.setIssueTime(new Date());
        claims.setExpirationTime(token.getExpiration());
        claims.setJWTID(UUID.randomUUID().toString());
        JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
        SignedJWT signed = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)claims);
        this.jwtService.signJwt(signed);
        token.setJwt((JWT)signed);
        if (authentication.getAuthorizationRequest().getScope().contains("openid")) {
            String responseType;
            Set responseTypes;
            Date authTime;
            HttpSession session;
            String userId = authentication.getName();
            OAuth2AccessTokenEntity idTokenEntity = new OAuth2AccessTokenEntity();
            JWTClaimsSet idClaims = new JWTClaimsSet();
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            if (attr != null && (session = attr.getRequest().getSession()) != null && (authTime = (Date)session.getAttribute("AUTH_TIMESTAMP")) != null) {
                idClaims.setClaim("auth_time", (Object)(authTime.getTime() / 1000L));
            }
            idClaims.setIssueTime(claims.getIssueTime());
            if (client.getIdTokenValiditySeconds() != null) {
                Date expiration = new Date(System.currentTimeMillis() + (long)client.getIdTokenValiditySeconds().intValue() * 1000L);
                idClaims.setExpirationTime(expiration);
                idTokenEntity.setExpiration(expiration);
            }
            idClaims.setIssuer(this.configBean.getIssuer());
            idClaims.setSubject(userId);
            idClaims.setAudience((List)Lists.newArrayList((Object[])new String[]{clientId}));
            String nonce = (String)authentication.getAuthorizationRequest().getAuthorizationParameters().get("nonce");
            if (!Strings.isNullOrEmpty((String)nonce)) {
                idClaims.setCustomClaim("nonce", (Object)nonce);
            }
            if ((responseTypes = OAuth2Utils.parseParameterList((String)(responseType = (String)authentication.getAuthorizationRequest().getAuthorizationParameters().get("response_type")))).contains("token")) {
                String algName = signingAlg.getName();
                Pattern re = Pattern.compile("^[HRE]S(\\d+)$");
                Matcher match = re.matcher(algName);
                if (match.matches()) {
                    String bits = match.group(1);
                    String hmacAlg = "HMACSHA" + bits;
                    try {
                        Mac mac = Mac.getInstance(hmacAlg);
                        mac.init(new SecretKeySpec(token.getJwt().serialize().getBytes(), hmacAlg));
                        byte[] at_hash_bytes = mac.doFinal();
                        byte[] at_hash_bytes_left = Arrays.copyOf(at_hash_bytes, at_hash_bytes.length / 2);
                        Base64URL at_hash = Base64URL.encode((byte[])at_hash_bytes_left);
                        idClaims.setClaim("at_hash", (Object)at_hash);
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidKeyException e) {
                        e.printStackTrace();
                    }
                }
            }
            SignedJWT idToken = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)idClaims);
            this.jwtService.signJwt(idToken);
            idTokenEntity.setJwt((JWT)idToken);
            idTokenEntity.setAuthenticationHolder(token.getAuthenticationHolder());
            HashSet idScopes = Sets.newHashSet((Object[])new String[]{"id-token"});
            idTokenEntity.setScope((Set)idScopes);
            idTokenEntity.setClient(token.getClient());
            token.setIdToken(idTokenEntity);
        }
        return token;
    }

    public ConfigurationPropertiesBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(ConfigurationPropertiesBean configBean) {
        this.configBean = configBean;
    }

    public JwtSigningAndValidationService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtSigningAndValidationService jwtService) {
        this.jwtService = jwtService;
    }

    public ClientDetailsEntityService getClientService() {
        return this.clientService;
    }

    public void setClientService(ClientDetailsEntityService clientService) {
        this.clientService = clientService;
    }
}

