/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.token;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.stereotype.Component;

@Component(value="tofuUserApprovalHandler")
public class TofuUserApprovalHandler
implements UserApprovalHandler {
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private WhitelistedSiteService whitelistedSiteService;
    @Autowired
    private ClientDetailsService clientDetailsService;

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        if (authorizationRequest.isApproved()) {
            return true;
        }
        boolean approved = Boolean.parseBoolean((String)authorizationRequest.getApprovalParameters().get("user_oauth_approval"));
        return userAuthentication.isAuthenticated() && approved;
    }

    private boolean scopesMatch(Set<String> requestedScopes, Set<String> allowedScopes) {
        for (String scope : requestedScopes) {
            if (allowedScopes.contains(scope)) continue;
            return false;
        }
        return true;
    }

    public AuthorizationRequest updateBeforeApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved;
        String userId = userAuthentication.getName();
        String clientId = authorizationRequest.getClientId();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        String prompt = (String)authorizationRequest.getAuthorizationParameters().get("prompt");
        if (!"consent".equals(prompt)) {
            Collection aps = this.approvedSiteService.getByClientIdAndUserId(clientId, userId);
            for (ApprovedSite ap : aps) {
                if (ap.isExpired() || !this.scopesMatch(authorizationRequest.getScope(), ap.getAllowedScopes())) continue;
                ap.setAccessDate(new Date());
                this.approvedSiteService.save(ap);
                DefaultAuthorizationRequest ar = new DefaultAuthorizationRequest(authorizationRequest);
                ar.setApproved(true);
                return ar;
            }
            WhitelistedSite ws = this.whitelistedSiteService.getByClientId(clientId);
            if (ws != null && this.scopesMatch(authorizationRequest.getScope(), ws.getAllowedScopes())) {
                this.approvedSiteService.createApprovedSite(clientId, userId, null, ws.getAllowedScopes(), ws);
                DefaultAuthorizationRequest ar = new DefaultAuthorizationRequest(authorizationRequest);
                ar.setApproved(true);
                return ar;
            }
        }
        if ((approved = Boolean.parseBoolean((String)authorizationRequest.getApprovalParameters().get("user_oauth_approval"))) && !authorizationRequest.getApprovalParameters().isEmpty()) {
            DefaultAuthorizationRequest ar = new DefaultAuthorizationRequest(authorizationRequest);
            HashSet allowedScopes = Sets.newHashSet();
            Map approvalParams = ar.getApprovalParameters();
            Set keys = approvalParams.keySet();
            for (String key : keys) {
                if (!key.startsWith("scope_")) continue;
                String scope = (String)approvalParams.get(key);
                if (!client.getScope().contains(scope)) continue;
                allowedScopes.add(scope);
            }
            ar.setScope((Set)allowedScopes);
            String remember = (String)ar.getApprovalParameters().get("remember");
            if (!Strings.isNullOrEmpty((String)remember) && !remember.equals("none")) {
                Date timeout = null;
                if (remember.equals("one-hour")) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(10, 1);
                    timeout = cal.getTime();
                }
                this.approvedSiteService.createApprovedSite(clientId, userId, timeout, (Set)allowedScopes, null);
            }
            return ar;
        }
        return authorizationRequest;
    }
}

