/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.common.base.CaseFormat;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="userInfoView")
public class UserInfoView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(UserInfoView.class);

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        UserInfo userInfo = (UserInfo)model.get("userInfo");
        Set scope = (Set)model.get("scope");
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new /* Unavailable Anonymous Inner Class!! */}).create();
        response.setContentType("application/json");
        try {
            PrintWriter out = response.getWriter();
            if (model.get("requestObject") != null) {
                try {
                    String jwtString = (String)model.get("requestObject");
                    JWT requestObject = JWTParser.parse((String)jwtString);
                    JsonObject obj = (JsonObject)new JsonParser().parse(requestObject.getJWTClaimsSet().toJSONObject().toJSONString());
                    gson.toJson((JsonElement)this.toJsonFromRequestObj(userInfo, scope, obj), (Appendable)out);
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
                catch (JsonIOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                gson.toJson((JsonElement)this.toJson(userInfo, scope), (Appendable)out);
            }
        }
        catch (IOException e) {
            logger.error("IOException in UserInfoView.java: ", (Throwable)e);
        }
    }

    private JsonObject toJson(UserInfo ui, Set<String> scope) {
        JsonObject obj = new JsonObject();
        if (scope.contains("openid")) {
            obj.addProperty("sub", ui.getSub());
        }
        if (scope.contains("profile")) {
            obj.addProperty("name", ui.getName());
            obj.addProperty("preferred_username", ui.getPreferredUsername());
            obj.addProperty("given_name", ui.getGivenName());
            obj.addProperty("family_name", ui.getFamilyName());
            obj.addProperty("middle_name", ui.getMiddleName());
            obj.addProperty("nickname", ui.getNickname());
            obj.addProperty("profile", ui.getProfile());
            obj.addProperty("picture", ui.getPicture());
            obj.addProperty("website", ui.getWebsite());
            obj.addProperty("gender", ui.getGender());
            obj.addProperty("zone_info", ui.getZoneinfo());
            obj.addProperty("locale", ui.getLocale());
            obj.addProperty("updated_time", ui.getUpdatedTime());
            obj.addProperty("birthdate", ui.getBirthdate());
        }
        if (scope.contains("email")) {
            obj.addProperty("email", ui.getEmail());
            obj.addProperty("email_verified", ui.getEmailVerified());
        }
        if (scope.contains("phone")) {
            obj.addProperty("phone_number", ui.getPhoneNumber());
        }
        if (scope.contains("address") && ui.getAddress() != null) {
            JsonObject addr = new JsonObject();
            addr.addProperty("formatted", ui.getAddress().getFormatted());
            addr.addProperty("street_address", ui.getAddress().getStreetAddress());
            addr.addProperty("locality", ui.getAddress().getLocality());
            addr.addProperty("region", ui.getAddress().getRegion());
            addr.addProperty("postal_code", ui.getAddress().getPostalCode());
            addr.addProperty("country", ui.getAddress().getCountry());
            obj.add("address", (JsonElement)addr);
        }
        return obj;
    }

    private JsonObject toJsonFromRequestObj(UserInfo ui, Set<String> scope, JsonObject requestObj) {
        JsonObject obj = this.toJson(ui, scope);
        JsonElement userInfo = requestObj.get("userinfo");
        if (userInfo == null || !userInfo.isJsonObject()) {
            return obj;
        }
        JsonElement claims = userInfo.getAsJsonObject().get("claims");
        if (claims == null || !claims.isJsonObject()) {
            return obj;
        }
        for (Map.Entry i : claims.getAsJsonObject().entrySet()) {
            String claimName = (String)i.getKey();
            if (obj.has(claimName)) continue;
            String value = "";
            String camelClaimName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, claimName);
            String methodName = "get" + camelClaimName;
            Method getter = null;
            try {
                getter = ui.getClass().getMethod(methodName, new Class[0]);
                value = (String)getter.invoke((Object)ui, new Object[0]);
                obj.addProperty(claimName, value);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }
}

