/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"register"})
public class ClientDynamicRegistrationEndpoint {
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private OAuth2TokenEntityService tokenService;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private ConfigurationPropertiesBean config;
    private static Logger logger = LoggerFactory.getLogger(ClientDynamicRegistrationEndpoint.class);

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String registerNewClient(@RequestBody String jsonString, Model m) {
        ClientDetailsEntity newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        if (newClient != null) {
            newClient.setClientId(null);
            newClient.setClientSecret(null);
            Set dynScopes = this.scopeService.getDynReg();
            Set requestedScopes = this.scopeService.fromStrings(newClient.getScope());
            if (requestedScopes == null || requestedScopes.isEmpty()) {
                requestedScopes = this.scopeService.getDefaults();
            }
            Sets.SetView allowedScopes = Sets.intersection((Set)dynScopes, (Set)requestedScopes);
            newClient.setScope(this.scopeService.toStrings((Set)allowedScopes));
            if (newClient.getGrantTypes() == null || newClient.getGrantTypes().isEmpty()) {
                if (newClient.getScope().contains("offline_access")) {
                    newClient.setGrantTypes((Set)Sets.newHashSet((Object[])new String[]{"authorization_code", "refresh_token"}));
                } else {
                    newClient.setGrantTypes((Set)Sets.newHashSet((Object[])new String[]{"authorization_code"}));
                }
            }
            if (newClient.getResponseTypes() == null || newClient.getResponseTypes().isEmpty()) {
                newClient.setResponseTypes((Set)Sets.newHashSet((Object[])new String[]{"code"}));
            }
            if (newClient.getTokenEndpointAuthMethod() == null) {
                newClient.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.SECRET_BASIC);
            }
            if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_BASIC || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_JWT || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_POST) {
                newClient = this.clientService.generateClientSecret(newClient);
            }
            newClient.setAccessTokenValiditySeconds(Integer.valueOf((int)TimeUnit.HOURS.toSeconds(1L)));
            newClient.setIdTokenValiditySeconds(Integer.valueOf((int)TimeUnit.MINUTES.toSeconds(10L)));
            newClient.setRefreshTokenValiditySeconds(null);
            newClient.setDynamicallyRegistered(true);
            ClientDetailsEntity savedClient = this.clientService.saveNewClient(newClient);
            OAuth2AccessTokenEntity token = this.createRegistrationAccessToken(savedClient);
            RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "register/" + savedClient.getClientId());
            m.addAttribute("client", (Object)registered);
            m.addAttribute("code", (Object)HttpStatus.CREATED);
            return "clientInformationResponseView";
        }
        logger.error("registerNewClient failed; submitted JSON is malformed");
        m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String readClientConfiguration(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getAuthorizationRequest().getClientId())) {
            OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)auth.getDetails();
            OAuth2AccessTokenEntity token = this.tokenService.readAccessToken(details.getTokenValue());
            RegisteredClient registered = new RegisteredClient(client, token.getValue(), this.config.getIssuer() + "register/" + client.getClientId());
            m.addAttribute("client", (Object)registered);
            m.addAttribute("code", (Object)HttpStatus.OK);
            return "clientInformationResponseView";
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getAuthorizationRequest().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    public String updateClient(@PathVariable(value="id") String clientId, @RequestBody String jsonString, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        ClientDetailsEntity oldClient = this.clientService.loadClientByClientId(clientId);
        if (newClient != null && oldClient != null && oldClient.getClientId().equals(auth.getAuthorizationRequest().getClientId()) && oldClient.getClientId().equals(newClient.getClientId())) {
            newClient.setClientSecret(oldClient.getClientSecret());
            newClient.setAccessTokenValiditySeconds(oldClient.getAccessTokenValiditySeconds());
            newClient.setIdTokenValiditySeconds(oldClient.getIdTokenValiditySeconds());
            newClient.setRefreshTokenValiditySeconds(oldClient.getRefreshTokenValiditySeconds());
            newClient.setDynamicallyRegistered(true);
            newClient.setAllowIntrospection(oldClient.isAllowIntrospection());
            newClient.setAuthorities(oldClient.getAuthorities());
            newClient.setClientDescription(oldClient.getClientDescription());
            newClient.setCreatedAt(oldClient.getCreatedAt());
            newClient.setReuseRefreshToken(oldClient.isReuseRefreshToken());
            Set dynScopes = this.scopeService.getDynReg();
            Set requestedScopes = this.scopeService.fromStrings(newClient.getScope());
            Sets.SetView allowedScopes = Sets.intersection((Set)dynScopes, (Set)requestedScopes);
            newClient.setScope(this.scopeService.toStrings((Set)allowedScopes));
            ClientDetailsEntity savedClient = this.clientService.updateClient(oldClient, newClient);
            OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)auth.getDetails();
            OAuth2AccessTokenEntity token = this.tokenService.readAccessToken(details.getTokenValue());
            RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "register/" + savedClient.getClientId());
            m.addAttribute("client", (Object)registered);
            m.addAttribute("code", (Object)HttpStatus.OK);
            return "clientInformationResponseView";
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getAuthorizationRequest().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteClient(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getAuthorizationRequest().getClientId())) {
            this.clientService.deleteClient(client);
            OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)auth.getDetails();
            OAuth2AccessTokenEntity token = this.tokenService.readAccessToken(details.getTokenValue());
            RegisteredClient registered = new RegisteredClient(client, token.getValue(), this.config.getIssuer() + "register/" + client.getClientId());
            m.addAttribute("client", (Object)client);
            m.addAttribute("code", (Object)HttpStatus.OK);
            return "clientInformationResponseView";
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getAuthorizationRequest().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    private OAuth2AccessTokenEntity createRegistrationAccessToken(ClientDetailsEntity client) throws AuthenticationException {
        DefaultAuthorizationRequest authorizationRequest = new DefaultAuthorizationRequest(client.getClientId(), (Collection)Sets.newHashSet((Object[])new String[]{"registration-token"}));
        authorizationRequest.setApproved(true);
        authorizationRequest.setAuthorities((Collection)Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_CLIENT")}));
        OAuth2Authentication authentication = new OAuth2Authentication((AuthorizationRequest)authorizationRequest, null);
        OAuth2AccessTokenEntity registrationAccessToken = (OAuth2AccessTokenEntity)this.tokenService.createAccessToken(authentication);
        return registrationAccessToken;
    }
}

