/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import java.security.Principal;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UserInfoEndpoint {
    @Autowired
    private UserInfoService userInfoService;
    private static Logger logger = LoggerFactory.getLogger(UserInfoEndpoint.class);

    @PreAuthorize(value="hasRole('ROLE_USER') and #oauth2.hasScope('openid')")
    @RequestMapping(value={"/userinfo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    public String getInfo(Principal p, Model model) {
        if (p == null) {
            logger.error("getInfo failed; no principal. Requester is not authorized.");
            model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
            return "httpCodeView";
        }
        String userId = p.getName();
        UserInfo userInfo = this.userInfoService.getBySubject(userId);
        if (userInfo == null) {
            logger.error("getInfo failed; user not found: " + userId);
            model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            return "httpCodeView";
        }
        if (p instanceof OAuth2Authentication) {
            OAuth2Authentication authentication = (OAuth2Authentication)p;
            model.addAttribute("scope", (Object)authentication.getAuthorizationRequest().getScope());
            model.addAttribute("requestObject", authentication.getAuthorizationRequest().getAuthorizationParameters().get("request"));
        }
        model.addAttribute("userInfo", (Object)userInfo);
        return "userInfoView";
    }
}

