/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.view;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.openid.connect.view.JsonEntityView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.servlet.view.AbstractView;

@Component(value="tokenApiView")
public class TokenApiView
extends AbstractView {
    public static final String VIEWNAME = "tokenApiView";
    private static Logger logger = LoggerFactory.getLogger(JsonEntityView.class);
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.equals(BeanPropertyBindingResult.class);
        }
    }}).registerTypeAdapter(OAuth2AccessTokenEntity.class, (Object)new JsonSerializer<OAuth2AccessTokenEntity>(){

        public JsonElement serialize(OAuth2AccessTokenEntity src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject o = new JsonObject();
            o.addProperty("value", src.getValue());
            o.addProperty("id", (Number)src.getId());
            o.addProperty("idTokenId", src.getIdToken() != null ? src.getIdToken().getId() : null);
            o.addProperty("refreshTokenId", src.getRefreshToken() != null ? src.getRefreshToken().getId() : null);
            o.add("scopes", context.serialize((Object)src.getScope()));
            o.addProperty("clientId", src.getClient().getClientId());
            o.addProperty("userId", src.getAuthenticationHolder().getAuthentication().getName());
            o.add("expiration", context.serialize((Object)src.getExpiration()));
            return o;
        }
    }).registerTypeAdapter(OAuth2RefreshTokenEntity.class, (Object)new JsonSerializer<OAuth2RefreshTokenEntity>(){

        public JsonElement serialize(OAuth2RefreshTokenEntity src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject o = new JsonObject();
            o.addProperty("value", src.getValue());
            o.addProperty("id", (Number)src.getId());
            o.add("scopes", context.serialize((Object)src.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope()));
            o.addProperty("clientId", src.getClient().getClientId());
            o.addProperty("userId", src.getAuthenticationHolder().getAuthentication().getName());
            o.add("expiration", context.serialize((Object)src.getExpiration()));
            return o;
        }
    }).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        try {
            PrintWriter out = response.getWriter();
            Object obj = model.get("entity");
            this.gson.toJson(obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in JsonEntityView.java: ", (Throwable)e);
        }
    }
}

