/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.assertion;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.assertion.JwtBearerAssertionAuthenticationToken;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;

public class JwtBearerClientAssertionTokenEndpointFilter
extends ClientCredentialsTokenEndpointFilter {
    public JwtBearerClientAssertionTokenEndpointFilter() {
    }

    public JwtBearerClientAssertionTokenEndpointFilter(String path) {
        super(path);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String assertionType = request.getParameter("client_assertion_type");
        String assertion = request.getParameter("client_assertion");
        try {
            JWT jwt = JWTParser.parse((String)assertion);
            String clientId = jwt.getJWTClaimsSet().getSubject();
            JwtBearerAssertionAuthenticationToken authRequest = new JwtBearerAssertionAuthenticationToken(clientId, jwt);
            return this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        catch (ParseException e) {
            throw new BadCredentialsException("Invalid JWT credential: " + assertion);
        }
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String assertionType = request.getParameter("client_assertion_type");
        String assertion = request.getParameter("client_assertion");
        if (Strings.isNullOrEmpty((String)assertionType) || Strings.isNullOrEmpty((String)assertion)) {
            return false;
        }
        if (!assertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            return false;
        }
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.getFilterProcessesUrl());
        }
        return uri.endsWith(request.getContextPath() + this.getFilterProcessesUrl());
    }
}

