/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.repository.BlacklistedSiteRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaBlacklistedSiteRepository
implements BlacklistedSiteRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public Collection<BlacklistedSite> getAll() {
        TypedQuery query = this.manager.createNamedQuery("BlacklistedSite.getAll", BlacklistedSite.class);
        return query.getResultList();
    }

    @Transactional
    public BlacklistedSite getById(Long id) {
        return (BlacklistedSite)this.manager.find(BlacklistedSite.class, (Object)id);
    }

    @Transactional
    public void remove(BlacklistedSite blacklistedSite) {
        BlacklistedSite found = (BlacklistedSite)this.manager.find(BlacklistedSite.class, (Object)blacklistedSite.getId());
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public BlacklistedSite save(BlacklistedSite blacklistedSite) {
        return (BlacklistedSite)JpaUtil.saveOrUpdate((Object)blacklistedSite.getId(), (EntityManager)this.manager, (Object)blacklistedSite);
    }

    @Transactional
    public BlacklistedSite update(BlacklistedSite oldBlacklistedSite, BlacklistedSite blacklistedSite) {
        blacklistedSite.setId(oldBlacklistedSite.getId());
        return (BlacklistedSite)JpaUtil.saveOrUpdate((Object)oldBlacklistedSite.getId(), (EntityManager)this.manager, (Object)blacklistedSite);
    }
}

