/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.openid.connect.service.ScopeClaimTranslationService;
import org.springframework.stereotype.Service;

@Service(value="scopeClaimTranslator")
public class DefaultScopeClaimTranslationService
implements ScopeClaimTranslationService {
    private SetMultimap<String, String> scopesToClaims = HashMultimap.create();
    private Map<String, String> claimsToFields = Maps.newHashMap();

    public DefaultScopeClaimTranslationService() {
        this.scopesToClaims.put((Object)"openid", (Object)"sub");
        this.scopesToClaims.put((Object)"profile", (Object)"name");
        this.scopesToClaims.put((Object)"profile", (Object)"preferred_username");
        this.scopesToClaims.put((Object)"profile", (Object)"given_name");
        this.scopesToClaims.put((Object)"profile", (Object)"family_name");
        this.scopesToClaims.put((Object)"profile", (Object)"middle_name");
        this.scopesToClaims.put((Object)"profile", (Object)"nickname");
        this.scopesToClaims.put((Object)"profile", (Object)"profile");
        this.scopesToClaims.put((Object)"profile", (Object)"picture");
        this.scopesToClaims.put((Object)"profile", (Object)"website");
        this.scopesToClaims.put((Object)"profile", (Object)"gender");
        this.scopesToClaims.put((Object)"profile", (Object)"zone_info");
        this.scopesToClaims.put((Object)"profile", (Object)"locale");
        this.scopesToClaims.put((Object)"profile", (Object)"updated_time");
        this.scopesToClaims.put((Object)"profile", (Object)"birthdate");
        this.scopesToClaims.put((Object)"email", (Object)"email");
        this.scopesToClaims.put((Object)"email", (Object)"email_verified");
        this.scopesToClaims.put((Object)"phone", (Object)"phone_number");
        this.scopesToClaims.put((Object)"phone", (Object)"phone_number_verified");
        this.scopesToClaims.put((Object)"address", (Object)"address");
        this.claimsToFields.put("sub", "sub");
        this.claimsToFields.put("name", "name");
        this.claimsToFields.put("preferred_username", "preferredUsername");
        this.claimsToFields.put("given_name", "givenName");
        this.claimsToFields.put("family_name", "familyName");
        this.claimsToFields.put("middle_name", "middleName");
        this.claimsToFields.put("nickname", "nickname");
        this.claimsToFields.put("profile", "profile");
        this.claimsToFields.put("picture", "picture");
        this.claimsToFields.put("website", "website");
        this.claimsToFields.put("gender", "gender");
        this.claimsToFields.put("zone_info", "zoneinfo");
        this.claimsToFields.put("locale", "locale");
        this.claimsToFields.put("updated_time", "updatedTime");
        this.claimsToFields.put("birthdate", "birthdate");
        this.claimsToFields.put("email", "email");
        this.claimsToFields.put("email_verified", "emailVerified");
        this.claimsToFields.put("phone_number", "phoneNumber");
        this.claimsToFields.put("phone_number_verified", "phoneNumberVerified");
        this.claimsToFields.put("address", "address");
    }

    public Set<String> getClaimsForScope(String scope) {
        if (this.scopesToClaims.containsKey((Object)scope)) {
            return this.scopesToClaims.get((Object)scope);
        }
        return new HashSet<String>();
    }

    public Set<String> getClaimsForScopeSet(Set<String> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (String scope : scopes) {
            result.addAll(this.getClaimsForScope(scope));
        }
        return result;
    }

    public String getFieldNameForClaim(String claim) {
        return this.claimsToFields.get(claim);
    }
}

