/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.repository.UserInfoRepository;
import org.mitre.openid.connect.service.PairwiseIdentiferService;
import org.mitre.openid.connect.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserInfoService
implements UserInfoService {
    @Autowired
    private UserInfoRepository userInfoRepository;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private PairwiseIdentiferService pairwiseIdentifierService;

    public void save(UserInfo userInfo) {
        this.userInfoRepository.save(userInfo);
    }

    public UserInfo getBySubject(String userId) {
        return this.userInfoRepository.getBySubject(userId);
    }

    public void remove(UserInfo userInfo) {
        this.userInfoRepository.remove(userInfo);
    }

    public UserInfo getByUsername(String username) {
        return this.userInfoRepository.getByUsername(username);
    }

    public UserInfo getByUsernameAndClientId(String username, String clientId) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        UserInfo userInfo = this.getByUsername(username);
        if (client == null || userInfo == null) {
            return null;
        }
        if (ClientDetailsEntity.SubjectType.PAIRWISE.equals((Object)client.getSubjectType())) {
            String pairwiseSub = this.pairwiseIdentifierService.getIdentifier(userInfo, client);
            userInfo.setSub(pairwiseSub);
        }
        return userInfo;
    }
}

