/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.repository.UserInfoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userInfoUserDetailsService")
public class DefaultUserInfoUserDetailsService
implements UserDetailsService {
    @Autowired
    private UserInfoRepository repository;
    public static final GrantedAuthority ROLE_USER = new SimpleGrantedAuthority("ROLE_USER");
    public static final GrantedAuthority ROLE_ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private List<String> admins = new ArrayList<String>();

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserInfo userInfo = this.repository.getByUsername(username);
        if (userInfo != null) {
            String password = "password";
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            authorities.add(ROLE_USER);
            if (this.admins != null && this.admins.contains(username)) {
                authorities.add(ROLE_ADMIN);
            }
            User user = new User(userInfo.getSub(), password, authorities);
            return user;
        }
        throw new UsernameNotFoundException("Could not find username: " + username);
    }

    public List<String> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<String> admins) {
        this.admins = admins;
    }
}

