/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.jose.JWEAlgorithmEmbed;
import org.mitre.jose.JWEEncryptionMethodEmbed;
import org.mitre.jose.JWSAlgorithmEmbed;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.repository.SystemScopeRepository;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.openid.connect.repository.BlacklistedSiteRepository;
import org.mitre.openid.connect.repository.WhitelistedSiteRepository;
import org.mitre.openid.connect.service.impl.MITREidDataService_1_X;
import org.mitre.openid.connect.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.stereotype.Service;

@Service
public class MITREidDataService_1_1
extends MITREidDataService_1_X {
    private static final Logger logger = LoggerFactory.getLogger(MITREidDataService_1_1.class);
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private ApprovedSiteRepository approvedSiteRepository;
    @Autowired
    private WhitelistedSiteRepository wlSiteRepository;
    @Autowired
    private BlacklistedSiteRepository blSiteRepository;
    @Autowired
    private AuthenticationHolderRepository authHolderRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private SystemScopeRepository sysScopeRepository;
    private Map<Long, String> refreshTokenToClientRefs = new HashMap<Long, String>();
    private Map<Long, Long> refreshTokenToAuthHolderRefs = new HashMap<Long, Long>();
    private Map<Long, Long> refreshTokenOldToNewIdMap = new HashMap<Long, Long>();
    private Map<Long, String> accessTokenToClientRefs = new HashMap<Long, String>();
    private Map<Long, Long> accessTokenToAuthHolderRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenToRefreshTokenRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenToIdTokenRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenOldToNewIdMap = new HashMap<Long, Long>();
    private Map<Long, Long> authHolderOldToNewIdMap = new HashMap<Long, Long>();
    Map<Long, Long> grantOldToNewIdMap = new HashMap<Long, Long>();
    Map<Long, Long> grantToWhitelistedSiteRefs = new HashMap<Long, Long>();
    Map<Long, Set<Long>> grantToAccessTokensRefs = new HashMap<Long, Set<Long>>();
    Map<Long, Long> whitelistedSiteOldToNewIdMap = new HashMap<Long, Long>();

    public void exportData(JsonWriter writer) throws IOException {
        writer.name("mitreid-connect-1.1");
        writer.beginObject();
        writer.name("clients");
        writer.beginArray();
        this.writeClients(writer);
        writer.endArray();
        writer.name("grants");
        writer.beginArray();
        this.writeGrants(writer);
        writer.endArray();
        writer.name("whitelistedSites");
        writer.beginArray();
        this.writeWhitelistedSites(writer);
        writer.endArray();
        writer.name("blacklistedSites");
        writer.beginArray();
        this.writeBlacklistedSites(writer);
        writer.endArray();
        writer.name("authenticationHolders");
        writer.beginArray();
        this.writeAuthenticationHolders(writer);
        writer.endArray();
        writer.name("accessTokens");
        writer.beginArray();
        this.writeAccessTokens(writer);
        writer.endArray();
        writer.name("refreshTokens");
        writer.beginArray();
        this.writeRefreshTokens(writer);
        writer.endArray();
        writer.name("systemScopes");
        writer.beginArray();
        this.writeSystemScopes(writer);
        writer.endArray();
        writer.endObject();
    }

    private void writeRefreshTokens(JsonWriter writer) throws IOException {
        for (OAuth2RefreshTokenEntity token : this.tokenRepository.getAllRefreshTokens()) {
            writer.beginObject();
            writer.name("id").value((Number)token.getId());
            writer.name("expiration").value(DateUtil.toUTCString(token.getExpiration()));
            writer.name("clientId").value(token.getClient() != null ? token.getClient().getClientId() : null);
            writer.name("authenticationHolderId").value(token.getAuthenticationHolder() != null ? token.getAuthenticationHolder().getId() : null);
            writer.name("value").value(token.getValue());
            writer.endObject();
            logger.debug("Wrote refresh token {}", (Object)token.getId());
        }
        logger.info("Done writing refresh tokens");
    }

    private void writeAccessTokens(JsonWriter writer) throws IOException {
        for (OAuth2AccessTokenEntity token : this.tokenRepository.getAllAccessTokens()) {
            writer.beginObject();
            writer.name("id").value((Number)token.getId());
            writer.name("expiration").value(DateUtil.toUTCString(token.getExpiration()));
            writer.name("clientId").value(token.getClient() != null ? token.getClient().getClientId() : null);
            writer.name("authenticationHolderId").value(token.getAuthenticationHolder() != null ? token.getAuthenticationHolder().getId() : null);
            writer.name("refreshTokenId").value(token.getRefreshToken() != null ? token.getRefreshToken().getId() : null);
            writer.name("idTokenId").value(token.getIdToken() != null ? token.getIdToken().getId() : null);
            writer.name("scope");
            writer.beginArray();
            for (String s : token.getScope()) {
                writer.value(s);
            }
            writer.endArray();
            writer.name("type").value(token.getTokenType());
            writer.name("value").value(token.getValue());
            writer.endObject();
            logger.debug("Wrote access token {}", (Object)token.getId());
        }
        logger.info("Done writing access tokens");
    }

    private void writeAuthenticationHolders(JsonWriter writer) throws IOException {
        for (AuthenticationHolderEntity holder : this.authHolderRepository.getAll()) {
            writer.beginObject();
            writer.name("id").value((Number)holder.getId());
            writer.name("ownerId").value((Number)holder.getOwnerId());
            writer.name("authentication");
            writer.beginObject();
            OAuth2Authentication oa2Auth = holder.getAuthentication();
            writer.name("clientAuthorization");
            this.writeAuthorizationRequest(oa2Auth.getOAuth2Request(), writer);
            String userAuthentication = MITREidDataService_1_1.base64UrlEncodeObject((Serializable)oa2Auth.getUserAuthentication());
            writer.name("userAuthentication").value(userAuthentication);
            writer.name("savedUserAuthentication");
            if (oa2Auth.getUserAuthentication() != null) {
                writer.beginObject();
                writer.name("name").value(oa2Auth.getUserAuthentication().getName());
                writer.name("sourceClass").value(oa2Auth.getUserAuthentication().getClass().getName());
                writer.name("authenticated").value(oa2Auth.getUserAuthentication().isAuthenticated());
                writer.name("authorities");
                writer.beginArray();
                for (GrantedAuthority authority : oa2Auth.getUserAuthentication().getAuthorities()) {
                    writer.value(authority.getAuthority());
                }
                writer.endArray();
                writer.endObject();
            } else {
                writer.nullValue();
            }
            writer.endObject();
            writer.endObject();
            logger.debug("Wrote authentication holder {}", (Object)holder.getId());
        }
        logger.info("Done writing authentication holders");
    }

    private void writeAuthorizationRequest(OAuth2Request authReq, JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("requestParameters");
        writer.beginObject();
        for (Map.Entry entry : authReq.getRequestParameters().entrySet()) {
            writer.name((String)entry.getKey()).value((String)entry.getValue());
        }
        writer.endObject();
        writer.name("clientId").value(authReq.getClientId());
        Set scope = authReq.getScope();
        writer.name("scope");
        writer.beginArray();
        for (String string : scope) {
            writer.value(string);
        }
        writer.endArray();
        writer.name("resourceIds");
        writer.beginArray();
        if (authReq.getResourceIds() != null) {
            for (String string : authReq.getResourceIds()) {
                writer.value(string);
            }
        }
        writer.endArray();
        writer.name("authorities");
        writer.beginArray();
        for (GrantedAuthority grantedAuthority : authReq.getAuthorities()) {
            writer.value(grantedAuthority.getAuthority());
        }
        writer.endArray();
        writer.name("approved").value(authReq.isApproved());
        writer.name("redirectUri").value(authReq.getRedirectUri());
        writer.name("responseTypes");
        writer.beginArray();
        for (String string : authReq.getResponseTypes()) {
            writer.value(string);
        }
        writer.endArray();
        writer.name("extensions");
        writer.beginObject();
        for (Map.Entry entry : authReq.getExtensions().entrySet()) {
            writer.name((String)entry.getKey()).value(MITREidDataService_1_1.base64UrlEncodeObject((Serializable)entry.getValue()));
        }
        writer.endObject();
        writer.name("extensionStrings");
        writer.beginObject();
        for (Map.Entry entry : authReq.getExtensions().entrySet()) {
            if (entry.getValue() instanceof String) {
                writer.name((String)entry.getKey()).value((String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                writer.name((String)entry.getKey()).value(((Long)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue() instanceof Date) {
                writer.name((String)entry.getKey()).value(Long.toString(((Date)entry.getValue()).getTime()));
                continue;
            }
            logger.warn("Skipping non-string extension: " + entry);
        }
        writer.endObject();
        writer.endObject();
    }

    private void writeGrants(JsonWriter writer) throws IOException {
        for (ApprovedSite site : this.approvedSiteRepository.getAll()) {
            writer.beginObject();
            writer.name("id").value((Number)site.getId());
            writer.name("accessDate").value(DateUtil.toUTCString(site.getAccessDate()));
            writer.name("clientId").value(site.getClientId());
            writer.name("creationDate").value(DateUtil.toUTCString(site.getCreationDate()));
            writer.name("timeoutDate").value(DateUtil.toUTCString(site.getTimeoutDate()));
            writer.name("userId").value(site.getUserId());
            writer.name("allowedScopes");
            this.writeNullSafeArray(writer, site.getAllowedScopes());
            writer.name("whitelistedSiteId").value(site.getIsWhitelisted() != false ? site.getWhitelistedSite().getId() : null);
            Set tokens = site.getApprovedAccessTokens();
            writer.name("approvedAccessTokens");
            writer.beginArray();
            for (OAuth2AccessTokenEntity token : tokens) {
                writer.value((Number)token.getId());
            }
            writer.endArray();
            writer.endObject();
            logger.debug("Wrote grant {}", (Object)site.getId());
        }
        logger.info("Done writing grants");
    }

    private void writeWhitelistedSites(JsonWriter writer) throws IOException {
        for (WhitelistedSite wlSite : this.wlSiteRepository.getAll()) {
            writer.beginObject();
            writer.name("id").value((Number)wlSite.getId());
            writer.name("clientId").value(wlSite.getClientId());
            writer.name("creatorUserId").value(wlSite.getCreatorUserId());
            writer.name("allowedScopes");
            this.writeNullSafeArray(writer, wlSite.getAllowedScopes());
            writer.endObject();
            logger.debug("Wrote whitelisted site {}", (Object)wlSite.getId());
        }
        logger.info("Done writing whitelisted sites");
    }

    private void writeBlacklistedSites(JsonWriter writer) throws IOException {
        for (BlacklistedSite blSite : this.blSiteRepository.getAll()) {
            writer.beginObject();
            writer.name("id").value((Number)blSite.getId());
            writer.name("uri").value(blSite.getUri());
            writer.endObject();
            logger.debug("Wrote blacklisted site {}", (Object)blSite.getId());
        }
        logger.info("Done writing blacklisted sites");
    }

    private void writeClients(JsonWriter writer) {
        for (ClientDetailsEntity client : this.clientRepository.getAllClients()) {
            try {
                writer.beginObject();
                writer.name("clientId").value(client.getClientId());
                writer.name("resourceIds");
                this.writeNullSafeArray(writer, client.getResourceIds());
                writer.name("secret").value(client.getClientSecret());
                writer.name("scope");
                this.writeNullSafeArray(writer, client.getScope());
                writer.name("authorities");
                writer.beginArray();
                for (GrantedAuthority authority : client.getAuthorities()) {
                    writer.value(authority.getAuthority());
                }
                writer.endArray();
                writer.name("accessTokenValiditySeconds").value((Number)client.getAccessTokenValiditySeconds());
                writer.name("refreshTokenValiditySeconds").value((Number)client.getRefreshTokenValiditySeconds());
                writer.name("redirectUris");
                this.writeNullSafeArray(writer, client.getRedirectUris());
                writer.name("name").value(client.getClientName());
                writer.name("uri").value(client.getClientUri());
                writer.name("logoUri").value(client.getLogoUri());
                writer.name("contacts");
                this.writeNullSafeArray(writer, client.getContacts());
                writer.name("tosUri").value(client.getTosUri());
                writer.name("tokenEndpointAuthMethod").value(client.getTokenEndpointAuthMethod() != null ? client.getTokenEndpointAuthMethod().getValue() : null);
                writer.name("grantTypes");
                writer.beginArray();
                for (String s : client.getGrantTypes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.name("responseTypes");
                writer.beginArray();
                for (String s : client.getResponseTypes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.name("policyUri").value(client.getPolicyUri());
                writer.name("jwksUri").value(client.getJwksUri());
                writer.name("applicationType").value(client.getApplicationType() != null ? client.getApplicationType().getValue() : null);
                writer.name("sectorIdentifierUri").value(client.getSectorIdentifierUri());
                writer.name("subjectType").value(client.getSubjectType() != null ? client.getSubjectType().getValue() : null);
                writer.name("requestObjectSigningAlg").value(client.getRequestObjectSigningAlgEmbed() != null ? client.getRequestObjectSigningAlgEmbed().getAlgorithmName() : null);
                writer.name("userInfoEncryptedResponseAlg").value(client.getUserInfoEncryptedResponseAlgEmbed() != null ? client.getUserInfoEncryptedResponseAlgEmbed().getAlgorithmName() : null);
                writer.name("userInfoEncryptedResponseEnc").value(client.getUserInfoEncryptedResponseEncEmbed() != null ? client.getUserInfoEncryptedResponseEncEmbed().getAlgorithmName() : null);
                writer.name("userInfoSignedResponseAlg").value(client.getUserInfoSignedResponseAlgEmbed() != null ? client.getUserInfoSignedResponseAlgEmbed().getAlgorithmName() : null);
                writer.name("defaultMaxAge").value((Number)client.getDefaultMaxAge());
                Boolean requireAuthTime = null;
                try {
                    requireAuthTime = client.getRequireAuthTime();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (requireAuthTime != null) {
                    writer.name("requireAuthTime").value(requireAuthTime.booleanValue());
                }
                writer.name("defaultACRValues");
                this.writeNullSafeArray(writer, client.getDefaultACRvalues());
                writer.name("intitateLoginUri").value(client.getInitiateLoginUri());
                writer.name("postLogoutRedirectUri").value(client.getPostLogoutRedirectUri());
                writer.name("requestUris");
                this.writeNullSafeArray(writer, client.getRequestUris());
                writer.name("description").value(client.getClientDescription());
                writer.name("allowIntrospection").value(client.isAllowIntrospection());
                writer.name("reuseRefreshToken").value(client.isReuseRefreshToken());
                writer.name("dynamicallyRegistered").value(client.isDynamicallyRegistered());
                writer.endObject();
                logger.debug("Wrote client {}", (Object)client.getId());
            }
            catch (IOException ex) {
                logger.error("Unable to write client {}", (Object)client.getId(), (Object)ex);
            }
        }
        logger.info("Done writing clients");
    }

    private void writeSystemScopes(JsonWriter writer) {
        for (SystemScope sysScope : this.sysScopeRepository.getAll()) {
            try {
                writer.beginObject();
                writer.name("id").value((Number)sysScope.getId());
                writer.name("description").value(sysScope.getDescription());
                writer.name("icon").value(sysScope.getIcon());
                writer.name("value").value(sysScope.getValue());
                writer.name("allowDynReg").value(sysScope.isAllowDynReg());
                writer.name("defaultScope").value(sysScope.isDefaultScope());
                writer.endObject();
                logger.debug("Wrote system scope {}", (Object)sysScope.getId());
            }
            catch (IOException ex) {
                logger.error("Unable to write system scope {}", (Object)sysScope.getId(), (Object)ex);
            }
        }
        logger.info("Done writing system scopes");
    }

    public void importData(JsonReader reader) throws IOException {
        logger.info("Reading configuration for 1.0");
        reader.beginObject();
        while (reader.hasNext()) {
            JsonToken tok = reader.peek();
            switch (tok) {
                case NAME: {
                    String name = reader.nextName();
                    if (name.equals("clients")) {
                        this.readClients(reader);
                        break;
                    }
                    if (name.equals("grants")) {
                        this.readGrants(reader);
                        break;
                    }
                    if (name.equals("whitelistedSites")) {
                        this.readWhitelistedSites(reader);
                        break;
                    }
                    if (name.equals("blacklistedSites")) {
                        this.readBlacklistedSites(reader);
                        break;
                    }
                    if (name.equals("authenticationHolders")) {
                        this.readAuthenticationHolders(reader);
                        break;
                    }
                    if (name.equals("accessTokens")) {
                        this.readAccessTokens(reader);
                        break;
                    }
                    if (name.equals("refreshTokens")) {
                        this.readRefreshTokens(reader);
                        break;
                    }
                    if (name.equals("systemScopes")) {
                        this.readSystemScopes(reader);
                        break;
                    }
                    reader.skipValue();
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    break;
                }
            }
        }
        this.fixObjectReferences();
    }

    private void readRefreshTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2RefreshTokenEntity token = new OAuth2RefreshTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            break;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            break;
                        }
                        if (name.equals("expiration")) {
                            Date date = DateUtil.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            break;
                        }
                        if (name.equals("value")) {
                            String value = reader.nextString();
                            try {
                                token.setValue(value);
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            break;
                        }
                        if (name.equals("clientId")) {
                            clientId = reader.nextString();
                            break;
                        }
                        if (name.equals("authenticationHolderId")) {
                            authHolderId = reader.nextLong();
                            break;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        break;
                    }
                    default: {
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveRefreshToken(token).getId();
            this.refreshTokenToClientRefs.put(currentId, clientId);
            this.refreshTokenToAuthHolderRefs.put(currentId, authHolderId);
            this.refreshTokenOldToNewIdMap.put(currentId, newId);
            logger.debug("Read refresh token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading refresh tokens");
    }

    private void readAccessTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            Long refreshTokenId = null;
            Long idTokenId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            break;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            break;
                        }
                        if (name.equals("expiration")) {
                            Date date = DateUtil.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            break;
                        }
                        if (name.equals("value")) {
                            String value = reader.nextString();
                            try {
                                token.setValue(value);
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            break;
                        }
                        if (name.equals("clientId")) {
                            clientId = reader.nextString();
                            break;
                        }
                        if (name.equals("authenticationHolderId")) {
                            authHolderId = reader.nextLong();
                            break;
                        }
                        if (name.equals("refreshTokenId")) {
                            refreshTokenId = reader.nextLong();
                            break;
                        }
                        if (name.equals("idTokenId")) {
                            idTokenId = reader.nextLong();
                            break;
                        }
                        if (name.equals("scope")) {
                            Set scope = MITREidDataService_1_1.readSet(reader);
                            token.setScope(scope);
                            break;
                        }
                        if (name.equals("type")) {
                            token.setTokenType(reader.nextString());
                            break;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        break;
                    }
                    default: {
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveAccessToken(token).getId();
            this.accessTokenToClientRefs.put(currentId, clientId);
            this.accessTokenToAuthHolderRefs.put(currentId, authHolderId);
            if (refreshTokenId != null) {
                this.accessTokenToRefreshTokenRefs.put(currentId, refreshTokenId);
            }
            if (idTokenId != null) {
                this.accessTokenToIdTokenRefs.put(currentId, idTokenId);
            }
            this.accessTokenOldToNewIdMap.put(currentId, newId);
            logger.debug("Read access token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading access tokens");
    }

    private void readAuthenticationHolders(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            AuthenticationHolderEntity ahe = new AuthenticationHolderEntity();
            reader.beginObject();
            Long currentId = null;
            block9: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block9;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block9;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block9;
                        }
                        if (name.equals("ownerId")) {
                            reader.skipValue();
                            continue block9;
                        }
                        if (name.equals("authentication")) {
                            OAuth2Request clientAuthorization = null;
                            Authentication userAuthentication = null;
                            reader.beginObject();
                            block10: while (reader.hasNext()) {
                                switch (reader.peek()) {
                                    case END_OBJECT: {
                                        continue block10;
                                    }
                                    case NAME: {
                                        String subName = reader.nextName();
                                        if (subName.equals("clientAuthorization")) {
                                            clientAuthorization = this.readAuthorizationRequest(reader);
                                            continue block10;
                                        }
                                        if (subName.equals("userAuthentication")) {
                                            if (reader.peek() == JsonToken.NULL) {
                                                reader.skipValue();
                                                continue block10;
                                            }
                                            String authString = reader.nextString();
                                            userAuthentication = MITREidDataService_1_1.base64UrlDecodeObject(authString, Authentication.class);
                                            continue block10;
                                        }
                                        logger.debug("Found unexpected entry");
                                        reader.skipValue();
                                        continue block10;
                                    }
                                }
                                logger.debug("Found unexpected entry");
                                reader.skipValue();
                            }
                            reader.endObject();
                            OAuth2Authentication auth = new OAuth2Authentication(clientAuthorization, userAuthentication);
                            ahe.setAuthentication(auth);
                            continue block9;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block9;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.authHolderRepository.save(ahe).getId();
            this.authHolderOldToNewIdMap.put(currentId, newId);
            logger.debug("Read authentication holder {}", currentId);
        }
        reader.endArray();
        logger.info("Done reading authentication holders");
    }

    private OAuth2Request readAuthorizationRequest(JsonReader reader) throws IOException {
        Set scope = new LinkedHashSet();
        Set resourceIds = new HashSet();
        boolean approved = false;
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        Map requestParameters = new HashMap();
        Set responseTypes = new HashSet();
        HashMap extensions = new HashMap();
        String redirectUri = null;
        String clientId = null;
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.peek()) {
                case END_OBJECT: {
                    continue block4;
                }
                case NAME: {
                    String name = reader.nextName();
                    if (reader.peek() == JsonToken.NULL) {
                        reader.skipValue();
                        break;
                    }
                    if (name.equals("requestParameters")) {
                        requestParameters = MITREidDataService_1_1.readMap(reader);
                        break;
                    }
                    if (name.equals("clientId")) {
                        clientId = reader.nextString();
                        break;
                    }
                    if (name.equals("scope")) {
                        scope = MITREidDataService_1_1.readSet(reader);
                        break;
                    }
                    if (name.equals("resourceIds")) {
                        resourceIds = MITREidDataService_1_1.readSet(reader);
                        break;
                    }
                    if (name.equals("authorities")) {
                        Set authorityStrs = MITREidDataService_1_1.readSet(reader);
                        authorities = new HashSet();
                        for (String string : authorityStrs) {
                            SimpleGrantedAuthority ga = new SimpleGrantedAuthority(string);
                            authorities.add(ga);
                        }
                        continue block4;
                    }
                    if (name.equals("approved")) {
                        approved = reader.nextBoolean();
                        break;
                    }
                    if (name.equals("denied")) {
                        if (approved) continue block4;
                        approved = !reader.nextBoolean();
                        break;
                    }
                    if (name.equals("redirectUri")) {
                        redirectUri = reader.nextString();
                        break;
                    }
                    if (name.equals("responseTypes")) {
                        responseTypes = MITREidDataService_1_1.readSet(reader);
                        break;
                    }
                    if (name.equals("extensions")) {
                        Map extEnc = MITREidDataService_1_1.readMap(reader);
                        for (Map.Entry entry : extEnc.entrySet()) {
                            Serializable decoded = MITREidDataService_1_1.base64UrlDecodeObject((String)entry.getValue(), Serializable.class);
                            if (decoded == null) continue;
                            extensions.put(entry.getKey(), decoded);
                        }
                        continue block4;
                    }
                    reader.skipValue();
                    break;
                }
                default: {
                    logger.debug("Found unexpected entry");
                    reader.skipValue();
                    continue block4;
                }
            }
        }
        reader.endObject();
        return new OAuth2Request(requestParameters, clientId, authorities, approved, scope, resourceIds, redirectUri, responseTypes, extensions);
    }

    private void readGrants(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ApprovedSite site = new ApprovedSite();
            Long currentId = null;
            Long whitelistedSiteId = null;
            Set tokenIds = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        Date date;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("accessDate")) {
                            date = DateUtil.utcToDate(reader.nextString());
                            site.setAccessDate(date);
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            site.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("creationDate")) {
                            date = DateUtil.utcToDate(reader.nextString());
                            site.setCreationDate(date);
                            continue block5;
                        }
                        if (name.equals("timeoutDate")) {
                            date = DateUtil.utcToDate(reader.nextString());
                            site.setTimeoutDate(date);
                            continue block5;
                        }
                        if (name.equals("userId")) {
                            site.setUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowedScopes")) {
                            Set allowedScopes = MITREidDataService_1_1.readSet(reader);
                            site.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        if (name.equals("whitelistedSiteId")) {
                            whitelistedSiteId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("approvedAccessTokens")) {
                            tokenIds = MITREidDataService_1_1.readSet(reader);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.approvedSiteRepository.save(site).getId();
            this.grantOldToNewIdMap.put(currentId, newId);
            if (whitelistedSiteId != null) {
                this.grantToWhitelistedSiteRefs.put(currentId, whitelistedSiteId);
            }
            if (tokenIds != null) {
                this.grantToAccessTokensRefs.put(currentId, tokenIds);
            }
            logger.debug("Read grant {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading grants");
    }

    private void readWhitelistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            WhitelistedSite wlSite = new WhitelistedSite();
            Long currentId = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals("id")) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            wlSite.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("creatorUserId")) {
                            wlSite.setCreatorUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowedScopes")) {
                            Set allowedScopes = MITREidDataService_1_1.readSet(reader);
                            wlSite.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.wlSiteRepository.save(wlSite).getId();
            this.whitelistedSiteOldToNewIdMap.put(currentId, newId);
        }
        reader.endArray();
        logger.info("Done reading whitelisted sites");
    }

    private void readBlacklistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            BlacklistedSite blSite = new BlacklistedSite();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals("id")) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("uri")) {
                            blSite.setUri(reader.nextString());
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.blSiteRepository.save(blSite);
        }
        reader.endArray();
        logger.info("Done reading blacklisted sites");
    }

    private void readClients(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ClientDetailsEntity client = new ClientDetailsEntity();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        JWSAlgorithmEmbed alg;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("clientId")) {
                            client.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("resourceIds")) {
                            Set resourceIds = MITREidDataService_1_1.readSet(reader);
                            client.setResourceIds(resourceIds);
                            continue block5;
                        }
                        if (name.equals("secret")) {
                            client.setClientSecret(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("scope")) {
                            Set scope = MITREidDataService_1_1.readSet(reader);
                            client.setScope(scope);
                            continue block5;
                        }
                        if (name.equals("authorities")) {
                            Set authorityStrs = MITREidDataService_1_1.readSet(reader);
                            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                            for (String s : authorityStrs) {
                                SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                                authorities.add(ga);
                            }
                            client.setAuthorities(authorities);
                            continue block5;
                        }
                        if (name.equals("accessTokenValiditySeconds")) {
                            client.setAccessTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("refreshTokenValiditySeconds")) {
                            client.setRefreshTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("redirectUris")) {
                            Set redirectUris = MITREidDataService_1_1.readSet(reader);
                            client.setRedirectUris(redirectUris);
                            continue block5;
                        }
                        if (name.equals("name")) {
                            client.setClientName(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("uri")) {
                            client.setClientUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("logoUri")) {
                            client.setLogoUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("contacts")) {
                            Set contacts = MITREidDataService_1_1.readSet(reader);
                            client.setContacts(contacts);
                            continue block5;
                        }
                        if (name.equals("tosUri")) {
                            client.setTosUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("tokenEndpointAuthMethod")) {
                            ClientDetailsEntity.AuthMethod am = ClientDetailsEntity.AuthMethod.getByValue((String)reader.nextString());
                            client.setTokenEndpointAuthMethod(am);
                            continue block5;
                        }
                        if (name.equals("grantTypes")) {
                            Set grantTypes = MITREidDataService_1_1.readSet(reader);
                            client.setGrantTypes(grantTypes);
                            continue block5;
                        }
                        if (name.equals("responseTypes")) {
                            Set responseTypes = MITREidDataService_1_1.readSet(reader);
                            client.setResponseTypes(responseTypes);
                            continue block5;
                        }
                        if (name.equals("policyUri")) {
                            client.setPolicyUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("applicationType")) {
                            ClientDetailsEntity.AppType appType = ClientDetailsEntity.AppType.getByValue((String)reader.nextString());
                            client.setApplicationType(appType);
                            continue block5;
                        }
                        if (name.equals("sectorIdentifierUri")) {
                            client.setSectorIdentifierUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("subjectType")) {
                            ClientDetailsEntity.SubjectType st = ClientDetailsEntity.SubjectType.getByValue((String)reader.nextString());
                            client.setSubjectType(st);
                            continue block5;
                        }
                        if (name.equals("requestObjectSigningAlg")) {
                            alg = JWSAlgorithmEmbed.getForAlgorithmName((String)reader.nextString());
                            client.setRequestObjectSigningAlgEmbed(alg);
                            continue block5;
                        }
                        if (name.equals("userInfoEncryptedResponseAlg")) {
                            alg = JWEAlgorithmEmbed.getForAlgorithmName((String)reader.nextString());
                            client.setUserInfoEncryptedResponseAlgEmbed((JWEAlgorithmEmbed)alg);
                            continue block5;
                        }
                        if (name.equals("userInfoEncryptedResponseEnc")) {
                            alg = JWEEncryptionMethodEmbed.getForAlgorithmName((String)reader.nextString());
                            client.setUserInfoEncryptedResponseEncEmbed((JWEEncryptionMethodEmbed)alg);
                            continue block5;
                        }
                        if (name.equals("userInfoSignedResponseAlg")) {
                            alg = JWSAlgorithmEmbed.getForAlgorithmName((String)reader.nextString());
                            client.setUserInfoSignedResponseAlgEmbed(alg);
                            continue block5;
                        }
                        if (name.equals("defaultMaxAge")) {
                            client.setDefaultMaxAge(Integer.valueOf(reader.nextInt()));
                            continue block5;
                        }
                        if (name.equals("requireAuthTime")) {
                            client.setRequireAuthTime(Boolean.valueOf(reader.nextBoolean()));
                            continue block5;
                        }
                        if (name.equals("defaultACRValues")) {
                            Set defaultACRvalues = MITREidDataService_1_1.readSet(reader);
                            client.setDefaultACRvalues(defaultACRvalues);
                            continue block5;
                        }
                        if (name.equals("initiateLoginUri")) {
                            client.setInitiateLoginUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("postLogoutRedirectUri")) {
                            client.setPostLogoutRedirectUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("requestUris")) {
                            Set requestUris = MITREidDataService_1_1.readSet(reader);
                            client.setRequestUris(requestUris);
                            continue block5;
                        }
                        if (name.equals("description")) {
                            client.setClientDescription(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowIntrospection")) {
                            client.setAllowIntrospection(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("reuseRefreshToken")) {
                            client.setReuseRefreshToken(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("dynamicallyRegistered")) {
                            client.setDynamicallyRegistered(reader.nextBoolean());
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.clientRepository.saveClient(client);
        }
        reader.endArray();
        logger.info("Done reading clients");
    }

    private void readSystemScopes(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            SystemScope scope = new SystemScope();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals("value")) {
                            scope.setValue(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("description")) {
                            scope.setDescription(reader.nextString());
                            continue block5;
                        }
                        if (name.equals("allowDynReg")) {
                            scope.setAllowDynReg(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("defaultScope")) {
                            scope.setDefaultScope(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals("icon")) {
                            scope.setIcon(reader.nextString());
                            continue block5;
                        }
                        logger.debug("found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.sysScopeRepository.save(scope);
        }
        reader.endArray();
        logger.info("Done reading system scopes");
    }

    private void fixObjectReferences() {
        OAuth2AccessTokenEntity accessToken;
        Long newAccessTokenId;
        AuthenticationHolderEntity authHolder;
        Long newAuthHolderId;
        Long oldAuthHolderId;
        ClientDetailsEntity client;
        String clientRef;
        for (Long oldRefreshTokenId : this.refreshTokenToClientRefs.keySet()) {
            clientRef = this.refreshTokenToClientRefs.get(oldRefreshTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setClient(client);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        this.refreshTokenToClientRefs.clear();
        for (Long oldRefreshTokenId : this.refreshTokenToAuthHolderRefs.keySet()) {
            oldAuthHolderId = this.refreshTokenToAuthHolderRefs.get(oldRefreshTokenId);
            newAuthHolderId = this.authHolderOldToNewIdMap.get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        this.refreshTokenToAuthHolderRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToClientRefs.keySet()) {
            clientRef = this.accessTokenToClientRefs.get(oldAccessTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newAccessTokenId2 = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            OAuth2AccessTokenEntity accessToken2 = this.tokenRepository.getAccessTokenById(newAccessTokenId2);
            accessToken2.setClient(client);
            this.tokenRepository.saveAccessToken(accessToken2);
        }
        this.accessTokenToClientRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToAuthHolderRefs.keySet()) {
            oldAuthHolderId = this.accessTokenToAuthHolderRefs.get(oldAccessTokenId);
            newAuthHolderId = this.authHolderOldToNewIdMap.get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToAuthHolderRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToRefreshTokenRefs.keySet()) {
            Long oldRefreshTokenId = this.accessTokenToRefreshTokenRefs.get(oldAccessTokenId);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setRefreshToken(refreshToken);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToRefreshTokenRefs.clear();
        this.refreshTokenOldToNewIdMap.clear();
        for (Long oldAccessTokenId : this.accessTokenToIdTokenRefs.keySet()) {
            Long oldIdTokenId = this.accessTokenToIdTokenRefs.get(oldAccessTokenId);
            Long newIdTokenId = this.accessTokenOldToNewIdMap.get(oldIdTokenId);
            OAuth2AccessTokenEntity idToken = this.tokenRepository.getAccessTokenById(newIdTokenId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setIdToken(idToken);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToIdTokenRefs.clear();
        for (Long oldGrantId : this.grantToWhitelistedSiteRefs.keySet()) {
            Long oldWhitelistedSiteId = this.grantToWhitelistedSiteRefs.get(oldGrantId);
            Long newWhitelistedSiteId = this.whitelistedSiteOldToNewIdMap.get(oldWhitelistedSiteId);
            WhitelistedSite wlSite = this.wlSiteRepository.getById(newWhitelistedSiteId);
            Long newGrantId = this.grantOldToNewIdMap.get(oldGrantId);
            ApprovedSite approvedSite = this.approvedSiteRepository.getById(newGrantId);
            approvedSite.setWhitelistedSite(wlSite);
            this.approvedSiteRepository.save(approvedSite);
        }
        this.grantToWhitelistedSiteRefs.clear();
        for (Long oldGrantId : this.grantToAccessTokensRefs.keySet()) {
            Set<Long> oldAccessTokenIds = this.grantToAccessTokensRefs.get(oldGrantId);
            HashSet<OAuth2AccessTokenEntity> tokens = new HashSet<OAuth2AccessTokenEntity>();
            for (Long oldTokenId : oldAccessTokenIds) {
                Long newTokenId = this.accessTokenOldToNewIdMap.get(oldTokenId);
                tokens.add(this.tokenRepository.getAccessTokenById(newTokenId));
            }
            Long newGrantId = this.grantOldToNewIdMap.get(oldGrantId);
            ApprovedSite site = this.approvedSiteRepository.getById(newGrantId);
            site.setApprovedAccessTokens(tokens);
            this.approvedSiteRepository.save(site);
        }
        this.accessTokenOldToNewIdMap.clear();
        this.grantOldToNewIdMap.clear();
    }
}

