/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.UUID;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.openid.connect.model.PairwiseIdentifier;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.repository.PairwiseIdentifierRepository;
import org.mitre.openid.connect.service.PairwiseIdentiferService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="uuidPairwiseIdentiferService")
public class UUIDPairwiseIdentiferService
implements PairwiseIdentiferService {
    private static Logger logger = LoggerFactory.getLogger(UUIDPairwiseIdentiferService.class);
    @Autowired
    private PairwiseIdentifierRepository pairwiseIdentifierRepository;

    public String getIdentifier(UserInfo userInfo, ClientDetailsEntity client) {
        String sectorIdentifier = null;
        if (!Strings.isNullOrEmpty((String)client.getSectorIdentifierUri())) {
            UriComponents uri = UriComponentsBuilder.fromUriString((String)client.getSectorIdentifierUri()).build();
            sectorIdentifier = uri.getHost();
        } else {
            Set redirectUris = client.getRedirectUris();
            UriComponents uri = UriComponentsBuilder.fromUriString((String)((String)Iterables.getOnlyElement((Iterable)redirectUris))).build();
            sectorIdentifier = uri.getHost();
        }
        if (sectorIdentifier != null) {
            PairwiseIdentifier pairwise = this.pairwiseIdentifierRepository.getBySectorIdentifier(userInfo.getSub(), sectorIdentifier);
            if (pairwise == null) {
                pairwise = new PairwiseIdentifier();
                pairwise.setIdentifier(UUID.randomUUID().toString());
                pairwise.setUserSub(userInfo.getSub());
                pairwise.setSectorIdentifier(sectorIdentifier);
                this.pairwiseIdentifierRepository.save(pairwise);
            }
            return pairwise.getIdentifier();
        }
        return null;
    }
}

