/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.jose.JWEAlgorithmEmbed;
import org.mitre.jose.JWEEncryptionMethodEmbed;
import org.mitre.jose.JWSAlgorithmEmbed;
import org.mitre.openid.connect.view.ClientEntityViewForAdmins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractClientEntityView
extends AbstractView {
    private static Logger logger = LoggerFactory.getLogger(ClientEntityViewForAdmins.class);
    private Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{this.getExclusionStrategy()}).registerTypeAdapter(JWSAlgorithmEmbed.class, (Object)new JsonSerializer<JWSAlgorithmEmbed>(){

        public JsonElement serialize(JWSAlgorithmEmbed src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getAlgorithmName());
            }
            return null;
        }
    }).registerTypeAdapter(JWEAlgorithmEmbed.class, (Object)new JsonSerializer<JWEAlgorithmEmbed>(){

        public JsonElement serialize(JWEAlgorithmEmbed src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getAlgorithmName());
            }
            return null;
        }
    }).registerTypeAdapter(JWEEncryptionMethodEmbed.class, (Object)new JsonSerializer<JWEEncryptionMethodEmbed>(){

        public JsonElement serialize(JWEEncryptionMethodEmbed src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                return new JsonPrimitive(src.getAlgorithmName());
            }
            return null;
        }
    }).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    protected abstract ExclusionStrategy getExclusionStrategy();

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        HttpStatus code = (HttpStatus)model.get("code");
        if (code == null) {
            code = HttpStatus.OK;
        }
        response.setStatus(code.value());
        try {
            PrintWriter out = response.getWriter();
            Object obj = model.get("entity");
            this.gson.toJson(obj, (Appendable)out);
        }
        catch (IOException e) {
            logger.error("IOException in JsonEntityView.java: ", (Throwable)e);
        }
    }
}

