/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.exception.ValidationException;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.mitre.openid.connect.service.OIDCTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value={"register"})
public class ClientDynamicRegistrationEndpoint {
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private OAuth2TokenEntityService tokenService;
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private BlacklistedSiteService blacklistService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private OIDCTokenService connectTokenService;
    private static Logger logger = LoggerFactory.getLogger(ClientDynamicRegistrationEndpoint.class);

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String registerNewClient(@RequestBody String jsonString, Model m) {
        ClientDetailsEntity newClient = null;
        try {
            newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            logger.error("registerNewClient failed; submitted JSON is malformed");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        if (newClient != null) {
            newClient.setClientId(null);
            newClient.setClientSecret(null);
            try {
                newClient = this.validateScopes(newClient);
                newClient = this.validateResponseTypes(newClient);
                newClient = this.validateGrantTypes(newClient);
                newClient = this.validateRedirectUris(newClient);
                newClient = this.validateAuth(newClient);
            }
            catch (ValidationException ve) {
                m.addAttribute("error", (Object)ve.getError());
                m.addAttribute("errorMessage", (Object)ve.getErrorDescription());
                m.addAttribute("code", (Object)ve.getStatus());
                return "jsonErrorView";
            }
            if (newClient.getTokenEndpointAuthMethod() == null) {
                newClient.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.SECRET_BASIC);
            }
            if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_BASIC || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_JWT || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_POST) {
                newClient = this.clientService.generateClientSecret(newClient);
            }
            newClient.setAccessTokenValiditySeconds(Integer.valueOf((int)TimeUnit.HOURS.toSeconds(1L)));
            newClient.setIdTokenValiditySeconds(Integer.valueOf((int)TimeUnit.MINUTES.toSeconds(10L)));
            newClient.setRefreshTokenValiditySeconds(null);
            newClient.setDynamicallyRegistered(true);
            newClient.setAllowIntrospection(false);
            try {
                ClientDetailsEntity savedClient = this.clientService.saveNewClient(newClient);
                OAuth2AccessTokenEntity token = this.connectTokenService.createRegistrationAccessToken(savedClient);
                token = this.tokenService.saveAccessToken(token);
                RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "register/" + UriUtils.encodePathSegment((String)savedClient.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.CREATED);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
            catch (IllegalArgumentException e) {
                logger.error("Couldn't save client", (Throwable)e);
                m.addAttribute("error", (Object)"invalid_client_metadata");
                m.addAttribute("errorMessage", (Object)"Unable to save client due to invalid or inconsistent metadata.");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                return "jsonErrorView";
            }
        }
        logger.error("registerNewClient failed; submitted JSON is malformed");
        m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String readClientConfiguration(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getOAuth2Request().getClientId())) {
            try {
                OAuth2AccessTokenEntity token = this.fetchValidRegistrationToken(auth, client);
                RegisteredClient registered = new RegisteredClient(client, token.getValue(), this.config.getIssuer() + "register/" + UriUtils.encodePathSegment((String)client.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.OK);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    public String updateClient(@PathVariable(value="id") String clientId, @RequestBody String jsonString, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity newClient = null;
        try {
            newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            logger.error("updateClient failed; submitted JSON is malformed");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        ClientDetailsEntity oldClient = this.clientService.loadClientByClientId(clientId);
        if (newClient != null && oldClient != null && oldClient.getClientId().equals(auth.getOAuth2Request().getClientId()) && oldClient.getClientId().equals(newClient.getClientId())) {
            newClient.setClientSecret(oldClient.getClientSecret());
            newClient.setAccessTokenValiditySeconds(oldClient.getAccessTokenValiditySeconds());
            newClient.setIdTokenValiditySeconds(oldClient.getIdTokenValiditySeconds());
            newClient.setRefreshTokenValiditySeconds(oldClient.getRefreshTokenValiditySeconds());
            newClient.setDynamicallyRegistered(true);
            newClient.setAllowIntrospection(false);
            newClient.setAuthorities(oldClient.getAuthorities());
            newClient.setClientDescription(oldClient.getClientDescription());
            newClient.setCreatedAt(oldClient.getCreatedAt());
            newClient.setReuseRefreshToken(oldClient.isReuseRefreshToken());
            try {
                newClient = this.validateScopes(newClient);
                newClient = this.validateResponseTypes(newClient);
                newClient = this.validateGrantTypes(newClient);
                newClient = this.validateRedirectUris(newClient);
                newClient = this.validateAuth(newClient);
            }
            catch (ValidationException ve) {
                m.addAttribute("error", (Object)ve.getError());
                m.addAttribute("errorMessage", (Object)ve.getErrorDescription());
                m.addAttribute("code", (Object)ve.getStatus());
                return "jsonErrorView";
            }
            try {
                ClientDetailsEntity savedClient = this.clientService.updateClient(oldClient, newClient);
                OAuth2AccessTokenEntity token = this.fetchValidRegistrationToken(auth, savedClient);
                RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "register/" + UriUtils.encodePathSegment((String)savedClient.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.OK);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
            catch (IllegalArgumentException e) {
                logger.error("Couldn't save client", (Throwable)e);
                m.addAttribute("error", (Object)"invalid_client_metadata");
                m.addAttribute("errorMessage", (Object)"Unable to save client due to invalid or inconsistent metadata.");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                return "jsonErrorView";
            }
        }
        logger.error("updateClient failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('registration-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteClient(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getOAuth2Request().getClientId())) {
            this.clientService.deleteClient(client);
            m.addAttribute("code", (Object)HttpStatus.NO_CONTENT);
            return "httpCodeView";
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    private ClientDetailsEntity validateScopes(ClientDetailsEntity newClient) throws ValidationException {
        Set requestedScopes;
        Set dynScopes = this.scopeService.getDynReg();
        Object allowedScopes = Sets.intersection((Set)dynScopes, (Set)(requestedScopes = this.scopeService.fromStrings(newClient.getScope())));
        if (allowedScopes == null || allowedScopes.isEmpty()) {
            allowedScopes = this.scopeService.getDefaults();
        }
        newClient.setScope(this.scopeService.toStrings((Set)allowedScopes));
        return newClient;
    }

    private ClientDetailsEntity validateResponseTypes(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getResponseTypes() == null) {
            newClient.setResponseTypes(new HashSet());
        }
        return newClient;
    }

    private ClientDetailsEntity validateGrantTypes(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getGrantTypes() == null || newClient.getGrantTypes().isEmpty()) {
            if (newClient.getScope().contains("offline_access")) {
                newClient.setGrantTypes((Set)Sets.newHashSet((Object[])new String[]{"authorization_code", "refresh_token"}));
            } else {
                newClient.setGrantTypes((Set)Sets.newHashSet((Object[])new String[]{"authorization_code"}));
            }
        }
        HashSet requestedGrantTypes = new HashSet(newClient.getGrantTypes());
        requestedGrantTypes.retainAll((Collection<?>)ImmutableSet.of((Object)"authorization_code", (Object)"implicit", (Object)"password", (Object)"client_credentials", (Object)"refresh_token", (Object)"urn:ietf:params:oauth:grant_type:redelegate", (Object[])new String[0]));
        if (newClient.getGrantTypes().contains("password")) {
            throw new ValidationException("invalid_client_metadata", "The password grant type is not allowed in dynamic registration on this server.", HttpStatus.BAD_REQUEST);
        }
        if (newClient.getGrantTypes().contains("authorization_code")) {
            if (newClient.getGrantTypes().contains("implicit") || newClient.getGrantTypes().contains("client_credentials")) {
                throw new ValidationException("invalid_client_metadata", "Incompatible grant types requested: " + newClient.getGrantTypes(), HttpStatus.BAD_REQUEST);
            }
            if (newClient.getResponseTypes().contains("token")) {
                throw new ValidationException("invalid_client_metadata", "Incompatible response types requested: " + newClient.getGrantTypes() + " / " + newClient.getResponseTypes(), HttpStatus.BAD_REQUEST);
            }
            newClient.getResponseTypes().add("code");
        }
        if (newClient.getGrantTypes().contains("implicit")) {
            if (newClient.getGrantTypes().contains("authorization_code") || newClient.getGrantTypes().contains("client_credentials")) {
                throw new ValidationException("invalid_client_metadata", "Incompatible grant types requested: " + newClient.getGrantTypes(), HttpStatus.BAD_REQUEST);
            }
            if (newClient.getResponseTypes().contains("code")) {
                throw new ValidationException("invalid_client_metadata", "Incompatible response types requested: " + newClient.getGrantTypes() + " / " + newClient.getResponseTypes(), HttpStatus.BAD_REQUEST);
            }
            newClient.getResponseTypes().add("token");
            newClient.getGrantTypes().remove("refresh_token");
            newClient.getScope().remove("offline_access");
        }
        if (newClient.getGrantTypes().contains("client_credentials")) {
            if (newClient.getGrantTypes().contains("authorization_code") || newClient.getGrantTypes().contains("implicit")) {
                throw new ValidationException("invalid_client_metadata", "Incompatible grant types requested: " + newClient.getGrantTypes(), HttpStatus.BAD_REQUEST);
            }
            if (!newClient.getResponseTypes().isEmpty()) {
                throw new ValidationException("invalid_client_metadata", "Incompatible response types requested: " + newClient.getGrantTypes() + " / " + newClient.getResponseTypes(), HttpStatus.BAD_REQUEST);
            }
            newClient.getGrantTypes().remove("refresh_token");
            newClient.getScope().remove("offline_access");
            newClient.getScope().remove("openid");
        }
        if (newClient.getGrantTypes().isEmpty()) {
            throw new ValidationException("invalid_client_metadata", "Clients must register at least one grant type.", HttpStatus.BAD_REQUEST);
        }
        return newClient;
    }

    private ClientDetailsEntity validateRedirectUris(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getGrantTypes().contains("authorization_code") || newClient.getGrantTypes().contains("implicit")) {
            if (newClient.getRedirectUris() == null || newClient.getRedirectUris().isEmpty()) {
                throw new ValidationException("invalid_redirect_uri", "Clients using a redirect-based grant type must register at least one redirect URI.", HttpStatus.BAD_REQUEST);
            }
            for (String uri : newClient.getRedirectUris()) {
                if (this.blacklistService.isBlacklisted(uri)) {
                    throw new ValidationException("invalid_redirect_uri", "Redirect URI is not allowed: " + uri, HttpStatus.BAD_REQUEST);
                }
                if (!uri.contains("#")) continue;
                throw new ValidationException("invalid_redirect_uri", "Redirect URI can not have a fragment", HttpStatus.BAD_REQUEST);
            }
        }
        return newClient;
    }

    private ClientDetailsEntity validateAuth(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getTokenEndpointAuthMethod() == null) {
            newClient.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.SECRET_BASIC);
        }
        if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_BASIC || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_JWT || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_POST) {
            if (Strings.isNullOrEmpty((String)newClient.getClientSecret())) {
                newClient = this.clientService.generateClientSecret(newClient);
            }
        } else if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.PRIVATE_KEY) {
            if (Strings.isNullOrEmpty((String)newClient.getJwksUri())) {
                throw new ValidationException("invalid_client_metadata", "JWK Set URI required when using private key authentication", HttpStatus.BAD_REQUEST);
            }
            newClient.setClientSecret(null);
        } else if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.NONE) {
            newClient.setClientSecret(null);
        } else {
            throw new ValidationException("invalid_client_metadata", "Unknown authentication method", HttpStatus.BAD_REQUEST);
        }
        return newClient;
    }

    private OAuth2AccessTokenEntity fetchValidRegistrationToken(OAuth2Authentication auth, ClientDetailsEntity client) {
        OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)auth.getDetails();
        OAuth2AccessTokenEntity token = this.tokenService.readAccessToken(details.getTokenValue());
        if (this.config.getRegTokenLifeTime() != null) {
            try {
                Date validToDate = new Date(System.currentTimeMillis() - this.config.getRegTokenLifeTime() * 1000L);
                if (token.getJwt().getJWTClaimsSet().getIssueTime().before(validToDate)) {
                    logger.info("Rotating the registration access token for " + client.getClientId());
                    this.tokenService.revokeAccessToken(token);
                    OAuth2AccessTokenEntity newToken = this.connectTokenService.createRegistrationAccessToken(client);
                    this.tokenService.saveAccessToken(newToken);
                    return newToken;
                }
                return token;
            }
            catch (ParseException e) {
                logger.error("Couldn't parse a known-valid token?", (Throwable)e);
                return token;
            }
        }
        return token;
    }
}

