/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.security.Principal;
import java.util.Collection;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/whitelist"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class WhitelistAPI {
    @Autowired
    private WhitelistedSiteService whitelistService;
    private static Logger logger = LoggerFactory.getLogger(WhitelistAPI.class);
    private Gson gson = new Gson();
    private JsonParser parser = new JsonParser();

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String getAllWhitelistedSites(ModelMap m) {
        Collection all = this.whitelistService.getAll();
        m.put((Object)"entity", (Object)all);
        return "jsonEntityView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String addNewWhitelistedSite(@RequestBody String jsonString, ModelMap m, Principal p) {
        WhitelistedSite whitelist = null;
        try {
            JsonObject json = this.parser.parse(jsonString).getAsJsonObject();
            whitelist = (WhitelistedSite)this.gson.fromJson((JsonElement)json, WhitelistedSite.class);
        }
        catch (JsonParseException e) {
            logger.error("addNewWhitelistedSite failed due to JsonParseException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new whitelisted site. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("addNewWhitelistedSite failed due to IllegalStateException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new whitelisted site. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        whitelist.setCreatorUserId(p.getName());
        WhitelistedSite newWhitelist = this.whitelistService.saveNew(whitelist);
        m.put((Object)"entity", (Object)newWhitelist);
        return "jsonEntityView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String updateWhitelistedSite(@PathVariable(value="id") Long id, @RequestBody String jsonString, ModelMap m, Principal p) {
        WhitelistedSite whitelist = null;
        try {
            JsonObject json = this.parser.parse(jsonString).getAsJsonObject();
            whitelist = (WhitelistedSite)this.gson.fromJson((JsonElement)json, WhitelistedSite.class);
        }
        catch (JsonParseException e) {
            logger.error("updateWhitelistedSite failed due to JsonParseException", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not update whitelisted site. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("updateWhitelistedSite failed due to IllegalStateException", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not update whitelisted site. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        WhitelistedSite oldWhitelist = this.whitelistService.getById(id);
        if (oldWhitelist == null) {
            logger.error("updateWhitelistedSite failed; whitelist with id " + id + " could not be found.");
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("Could not update whitelisted site. The requested whitelisted site with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        WhitelistedSite newWhitelist = this.whitelistService.update(oldWhitelist, whitelist);
        m.put((Object)"entity", (Object)newWhitelist);
        return "jsonEntityView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String deleteWhitelistedSite(@PathVariable(value="id") Long id, ModelMap m) {
        WhitelistedSite whitelist = this.whitelistService.getById(id);
        if (whitelist == null) {
            logger.error("deleteWhitelistedSite failed; whitelist with id " + id + " could not be found.");
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("Could not delete whitelisted site. The requested whitelisted site with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        m.put((Object)"code", (Object)HttpStatus.OK);
        this.whitelistService.remove(whitelist);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getWhitelistedSite(@PathVariable(value="id") Long id, ModelMap m) {
        WhitelistedSite whitelist = this.whitelistService.getById(id);
        if (whitelist == null) {
            logger.error("getWhitelistedSite failed; whitelist with id " + id + " could not be found.");
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("The requested whitelisted site with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        m.put((Object)"entity", (Object)whitelist);
        return "jsonEntityView";
    }
}

